package com.gingersoft.gsa.cloud.bean.mvp.model.service;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.bean.mvp.model.bean.BaseOrderRespose;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * Created by Wyh on 2020/1/17.
 */
public interface OrderService {

    @FormUrlEncoded
    @POST("order/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> loadOrderList(@Field("restaurantId") int restaurantId, @Field("orderType") String orderType, @Field("pageIndex") int pageIndex, @Field("pageSize") int pageSize);

    @GET("order/pay/success" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getOrderDetail(@Query("orderId") long orderId);

    @GET("order/findOrderById" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseOrderRespose> getOrderById(@Query("orderId") long orderId);

    @FormUrlEncoded
    @POST("order/cancel" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> cancelOrder(@Field("orderId") long orderId);


}
