package com.gingersoft.gsa.cloud.database.greendao;

import java.util.Map;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.AbstractDaoSession;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.identityscope.IdentityScopeType;
import org.greenrobot.greendao.internal.DaoConfig;

import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.database.bean.ExpandInfo;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.FoodCombo;
import com.gingersoft.gsa.cloud.database.bean.FoodModifier;
import com.gingersoft.gsa.cloud.database.bean.Function;
import com.gingersoft.gsa.cloud.database.bean.Language;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.bean.PrintCurrencyBean;
import com.gingersoft.gsa.cloud.database.bean.PrintModelBean;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;

import com.gingersoft.gsa.cloud.database.greendao.ComboItemDao;
import com.gingersoft.gsa.cloud.database.greendao.DiscountDao;
import com.gingersoft.gsa.cloud.database.greendao.ExpandInfoDao;
import com.gingersoft.gsa.cloud.database.greendao.FoodDao;
import com.gingersoft.gsa.cloud.database.greendao.FoodComboDao;
import com.gingersoft.gsa.cloud.database.greendao.FoodModifierDao;
import com.gingersoft.gsa.cloud.database.greendao.FunctionDao;
import com.gingersoft.gsa.cloud.database.greendao.LanguageDao;
import com.gingersoft.gsa.cloud.database.greendao.ModifierDao;
import com.gingersoft.gsa.cloud.database.greendao.PrintCurrencyBeanDao;
import com.gingersoft.gsa.cloud.database.greendao.PrintModelBeanDao;
import com.gingersoft.gsa.cloud.database.greendao.PrinterDeviceBeanDao;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.

/**
 * {@inheritDoc}
 * 
 * @see org.greenrobot.greendao.AbstractDaoSession
 */
public class DaoSession extends AbstractDaoSession {

    private final DaoConfig comboItemDaoConfig;
    private final DaoConfig discountDaoConfig;
    private final DaoConfig expandInfoDaoConfig;
    private final DaoConfig foodDaoConfig;
    private final DaoConfig foodComboDaoConfig;
    private final DaoConfig foodModifierDaoConfig;
    private final DaoConfig functionDaoConfig;
    private final DaoConfig languageDaoConfig;
    private final DaoConfig modifierDaoConfig;
    private final DaoConfig printCurrencyBeanDaoConfig;
    private final DaoConfig printModelBeanDaoConfig;
    private final DaoConfig printerDeviceBeanDaoConfig;

    private final ComboItemDao comboItemDao;
    private final DiscountDao discountDao;
    private final ExpandInfoDao expandInfoDao;
    private final FoodDao foodDao;
    private final FoodComboDao foodComboDao;
    private final FoodModifierDao foodModifierDao;
    private final FunctionDao functionDao;
    private final LanguageDao languageDao;
    private final ModifierDao modifierDao;
    private final PrintCurrencyBeanDao printCurrencyBeanDao;
    private final PrintModelBeanDao printModelBeanDao;
    private final PrinterDeviceBeanDao printerDeviceBeanDao;

    public DaoSession(Database db, IdentityScopeType type, Map<Class<? extends AbstractDao<?, ?>>, DaoConfig>
            daoConfigMap) {
        super(db);

        comboItemDaoConfig = daoConfigMap.get(ComboItemDao.class).clone();
        comboItemDaoConfig.initIdentityScope(type);

        discountDaoConfig = daoConfigMap.get(DiscountDao.class).clone();
        discountDaoConfig.initIdentityScope(type);

        expandInfoDaoConfig = daoConfigMap.get(ExpandInfoDao.class).clone();
        expandInfoDaoConfig.initIdentityScope(type);

        foodDaoConfig = daoConfigMap.get(FoodDao.class).clone();
        foodDaoConfig.initIdentityScope(type);

        foodComboDaoConfig = daoConfigMap.get(FoodComboDao.class).clone();
        foodComboDaoConfig.initIdentityScope(type);

        foodModifierDaoConfig = daoConfigMap.get(FoodModifierDao.class).clone();
        foodModifierDaoConfig.initIdentityScope(type);

        functionDaoConfig = daoConfigMap.get(FunctionDao.class).clone();
        functionDaoConfig.initIdentityScope(type);

        languageDaoConfig = daoConfigMap.get(LanguageDao.class).clone();
        languageDaoConfig.initIdentityScope(type);

        modifierDaoConfig = daoConfigMap.get(ModifierDao.class).clone();
        modifierDaoConfig.initIdentityScope(type);

        printCurrencyBeanDaoConfig = daoConfigMap.get(PrintCurrencyBeanDao.class).clone();
        printCurrencyBeanDaoConfig.initIdentityScope(type);

        printModelBeanDaoConfig = daoConfigMap.get(PrintModelBeanDao.class).clone();
        printModelBeanDaoConfig.initIdentityScope(type);

        printerDeviceBeanDaoConfig = daoConfigMap.get(PrinterDeviceBeanDao.class).clone();
        printerDeviceBeanDaoConfig.initIdentityScope(type);

        comboItemDao = new ComboItemDao(comboItemDaoConfig, this);
        discountDao = new DiscountDao(discountDaoConfig, this);
        expandInfoDao = new ExpandInfoDao(expandInfoDaoConfig, this);
        foodDao = new FoodDao(foodDaoConfig, this);
        foodComboDao = new FoodComboDao(foodComboDaoConfig, this);
        foodModifierDao = new FoodModifierDao(foodModifierDaoConfig, this);
        functionDao = new FunctionDao(functionDaoConfig, this);
        languageDao = new LanguageDao(languageDaoConfig, this);
        modifierDao = new ModifierDao(modifierDaoConfig, this);
        printCurrencyBeanDao = new PrintCurrencyBeanDao(printCurrencyBeanDaoConfig, this);
        printModelBeanDao = new PrintModelBeanDao(printModelBeanDaoConfig, this);
        printerDeviceBeanDao = new PrinterDeviceBeanDao(printerDeviceBeanDaoConfig, this);

        registerDao(ComboItem.class, comboItemDao);
        registerDao(Discount.class, discountDao);
        registerDao(ExpandInfo.class, expandInfoDao);
        registerDao(Food.class, foodDao);
        registerDao(FoodCombo.class, foodComboDao);
        registerDao(FoodModifier.class, foodModifierDao);
        registerDao(Function.class, functionDao);
        registerDao(Language.class, languageDao);
        registerDao(Modifier.class, modifierDao);
        registerDao(PrintCurrencyBean.class, printCurrencyBeanDao);
        registerDao(PrintModelBean.class, printModelBeanDao);
        registerDao(PrinterDeviceBean.class, printerDeviceBeanDao);
    }
    
    public void clear() {
        comboItemDaoConfig.clearIdentityScope();
        discountDaoConfig.clearIdentityScope();
        expandInfoDaoConfig.clearIdentityScope();
        foodDaoConfig.clearIdentityScope();
        foodComboDaoConfig.clearIdentityScope();
        foodModifierDaoConfig.clearIdentityScope();
        functionDaoConfig.clearIdentityScope();
        languageDaoConfig.clearIdentityScope();
        modifierDaoConfig.clearIdentityScope();
        printCurrencyBeanDaoConfig.clearIdentityScope();
        printModelBeanDaoConfig.clearIdentityScope();
        printerDeviceBeanDaoConfig.clearIdentityScope();
    }

    public ComboItemDao getComboItemDao() {
        return comboItemDao;
    }

    public DiscountDao getDiscountDao() {
        return discountDao;
    }

    public ExpandInfoDao getExpandInfoDao() {
        return expandInfoDao;
    }

    public FoodDao getFoodDao() {
        return foodDao;
    }

    public FoodComboDao getFoodComboDao() {
        return foodComboDao;
    }

    public FoodModifierDao getFoodModifierDao() {
        return foodModifierDao;
    }

    public FunctionDao getFunctionDao() {
        return functionDao;
    }

    public LanguageDao getLanguageDao() {
        return languageDao;
    }

    public ModifierDao getModifierDao() {
        return modifierDao;
    }

    public PrintCurrencyBeanDao getPrintCurrencyBeanDao() {
        return printCurrencyBeanDao;
    }

    public PrintModelBeanDao getPrintModelBeanDao() {
        return printModelBeanDao;
    }

    public PrinterDeviceBeanDao getPrinterDeviceBeanDao() {
        return printerDeviceBeanDao;
    }

}
