package com.gingersoft.gsa.cloud.common.core.print.bean.base;

import android.os.Parcel;
import android.os.Parcelable;

import lombok.Data;

/**
 * 賬單支付方式實體
 */
@Data
public class PrintPayTypeItem implements Parcelable {

    private String payName;
    private String payAmount;


    public PrintPayTypeItem(String payName, String payAmount) {
        this.payName = payName;
        this.payAmount = payAmount;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.payName);
        dest.writeString(this.payAmount);
    }

    protected PrintPayTypeItem(Parcel in) {
        this.payName = in.readString();
        this.payAmount = in.readString();
    }

    public static final Creator<PrintPayTypeItem> CREATOR = new Creator<PrintPayTypeItem>() {
        @Override
        public PrintPayTypeItem createFromParcel(Parcel source) {
            return new PrintPayTypeItem(source);
        }

        @Override
        public PrintPayTypeItem[] newArray(int size) {
            return new PrintPayTypeItem[size];
        }
    };
}
