package com.gingersoft.gsa.cloud.common.core.order.cart;

import android.text.TextUtils;

import com.gingersoft.gsa.cloud.common.core.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;

import java.util.List;

/**
 * @author : bin
 * @create date: 2020-10-26
 * @update date: 2020-10-26
 * @description:數量改變器
 */
public class ShoppingCartNumberChange {

    protected List<OrderDetail> mOrderCommodityList;

    public ShoppingCartNumberChange(List<OrderDetail> orderCommodityList) {
        this.mOrderCommodityList = orderCommodityList;
    }

    public void changeNumber(int number,OrderDetail orderFood, OrderDetail orderMainFood,int select_Full_start_position,int select_Full_end_position, OnNumberChangeListener listener) {
        changeFoodNumber(orderFood, number, listener);
        changeChildNumber(orderFood, orderMainFood,select_Full_start_position,select_Full_end_position, number, listener);
    }

    private void changeFoodNumber(OrderDetail orderFood, int number, OnNumberChangeListener listener) {
        String currentMaxNumber = orderFood.getCurrentMaxNumber();
        if (!TextUtils.isEmpty(currentMaxNumber)) {
            if (number > Integer.parseInt(currentMaxNumber)) {
                if (listener != null) {
                    listener.achieveMaximum(orderFood.getProductName());
                }
                orderFood.setNumber(Integer.parseInt(currentMaxNumber));
            } else {
                orderFood.setNumber(number);
            }
        } else {
            orderFood.setNumber(number);
        }
        setCalculatePrice(orderFood);
    }

    private void changeChildNumber(OrderDetail orderFood, OrderDetail orderMainFood,int select_Full_start_position,int select_Full_end_position, int number, OnNumberChangeListener listener) {
        int parentIndex = orderFood.getMyIndex();
        int mainNumber = orderMainFood.getNumber();
        if (orderMainFood.getItemType() == 1 && mainNumber == 1) {
            //主食品金额为1 子食品金额也为1
            for (int i = select_Full_start_position; i <= select_Full_end_position; i++) {
                OrderDetail datasBean = mOrderCommodityList.get(i);
                if (datasBean.getParentIndex() == parentIndex) {
                    datasBean.setNumber(1);
                    setCalculatePrice(datasBean);
                }
            }
        } else {
            for (int i = select_Full_start_position; i <= select_Full_end_position; i++) {
                OrderDetail datasBean = mOrderCommodityList.get(i);
                if (datasBean.getParentIndex() == parentIndex) {
//                    if (datasBean.getNumber() == 1) {
                    String currentMaxNumber = datasBean.getCurrentMaxNumber();
                    if (!TextUtils.isEmpty(currentMaxNumber)) {
                        if (number > Integer.parseInt(currentMaxNumber)) {
                            datasBean.setNumber(Integer.parseInt(currentMaxNumber));
                        } else {
                            datasBean.setNumber(number);
                        }
                    } else {
                        datasBean.setNumber(number);
                    }
                    setCalculatePrice(datasBean);
                }
            }
        }
    }

    public void setCalculatePrice(OrderDetail datasBean) {
        double money = datasBean.getUnit_price();
        datasBean.setUnit_price(money);
        datasBean.setPrice(MoneyUtil.multiply(money, datasBean.getNumber()));
    }

    public interface OnNumberChangeListener {
        void achieveMaximum(String name);
    }

}
