package com.gingersoft.gsa.cloud.login.mvp.server;


import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.ui.bean.mode.BrandsBean;
import com.gingersoft.gsa.cloud.common.ui.bean.mode.LoginBean;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;

/**
 * Created by Wyh on 2019/12/20.
 */
public interface LoginService {

    @Headers({"Domain-Name: system_url"})
    @POST("public/user/login" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<LoginBean> login(@Body RequestBody requestBody);

    @GET("user/brand/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BrandsBean> getRestaurantList();

    @FormUrlEncoded
    @POST("user/restrictions" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getLoginLimit(@Field("restaurantId") int restaurantId);

    @POST("user/logout" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<Object> loginOut(@Header("uid") int userId, @Body RequestBody requestBody);
}
