package com.gingersoft.gsa.cloud.main.mvp.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.ui.widget.BaseReloadView;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DailyReportBean;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.DailyBusinessAdapter;

import java.util.List;

public class OperatingReportView extends BaseReloadView {

    private boolean isPrint = false;
    private DailyBusinessAdapter adapter;
    private List<DailyReportBean> dailyReportBeans;
    private int spanCount;
    private String title;

    public OperatingReportView(@NonNull Context context) {
        this(context, null);
    }

    public OperatingReportView(@NonNull Context context, boolean isPrint, String title, List<DailyReportBean> dailyReportBeans, int spanCount) {
        this(context, null);
        this.isPrint = isPrint;
        this.dailyReportBeans = dailyReportBeans;
        this.spanCount = spanCount;
        this.title = title;
    }


    public OperatingReportView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public OperatingReportView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public boolean getDataIsNull() {
        return !isPrint && dailyReportBeans == null;
    }

    @Override
    public ViewGroup getChildView() {
        View view = View.inflate(getContext(), R.layout.layout_report_net_operating_value_details, null);
        TextView tvTitle = view.findViewById(R.id.tv_report_title);
        tvTitle.setText(title);

        RecyclerView rv = view.findViewById(R.id.rv_business_details);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(getContext()) {
            @Override
            public boolean canScrollVertically() {
                return false;
            }
        };
        rv.setLayoutManager(linearLayoutManager);
        adapter = new DailyBusinessAdapter(getContext(), dailyReportBeans, spanCount, isPrint);
        rv.setAdapter(adapter);

        if (isPrint) {
            tvTitle.setTextSize(30);
        }
        notifyData(dailyReportBeans);
        return view.findViewById(R.id.layout_business_info);
    }

    @Override
    public void refreshData() {
        if (adapter != null) {
            adapter.setNewInstance(dailyReportBeans);
        } else {

        }
    }

//    private void init(Context mContext, String title, List<DailyReportBean> dailyReportBeans, int spanCount) {
//        View view = View.inflate(mContext, R.layout.layout_report_net_operating_value_details, null);
//        TextView tvTitle = view.findViewById(R.id.tv_report_title);
//        tvTitle.setText(title);
//
//        RecyclerView rv = view.findViewById(R.id.rv_business_details);
//        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(mContext) {
//            @Override
//            public boolean canScrollVertically() {
//                return false;
//            }
//        };
//        rv.setLayoutManager(linearLayoutManager);
//        adapter = new DailyBusinessAdapter(mContext, dailyReportBeans, spanCount, isPrint);
//        rv.setAdapter(adapter);
//
//        if (isPrint) {
//            tvTitle.setTextSize(30);
//        }
//        notifyData(dailyReportBeans);
//        addView(view);
//    }

    public void notifyData(List<DailyReportBean> dailyReportBeans) {
        this.dailyReportBeans = dailyReportBeans;
    }

}
