package com.gingersoft.gsa.cloud.table.mvp.model.discount;

import android.app.Activity;
import android.text.InputType;

import com.gingersoft.gsa.cloud.common.core.order.discount.NomalDiscount;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.common.patterns.Strategy;
import com.gingersoft.gsa.cloud.table.mvp.ui.widget.KeyboardDialog;
import com.gingersoft.gsa.cloud.common.ui.widget.dialog.CommonTipDialog;
import com.jess.arms.utils.ArmsUtils;

import java.util.List;

/**
 * @author : bin
 * @create date: 2020-10-27
 * @update date: 2020-10-27
 * @description:賬單折扣邏輯
 */
public class BillDiscountAction implements Strategy<Discount> {

    private Activity mContext;

    /**
     * 賬單折扣列表
     */
    private List<NomalDiscount> mNomalDiscountList;

    private OnCallBackListener mListener;

    public BillDiscountAction(Activity context, OnCallBackListener listener) {
        this.mContext = context;
        this.mListener = listener;
    }

    public void setNomalDiscountList(List<NomalDiscount> nomalDiscountList) {
        this.mNomalDiscountList = nomalDiscountList;
    }

    @Override
    public void action(Discount discount) {
        if (mListener == null) {
            return;
        }
        if (isOnlyOnce(discount)) {
            //此折扣只一次
            ArmsUtils.makeText(mContext, "此折扣只一次");
            return;
        }
        boolean hasExclusive = hasExclusiveDiscount();
        if (hasExclusive) {
            //有獨佔折扣
            exclusiveDiscount(discount);
            return;
        } else {
            if (discount.getExclusive() == 1 && mNomalDiscountList.size() > 0) {
                //獨佔折扣
                exclusiveDiscount(discount);
                return;
            }
        }
        switch (discount.getType()) {
            case Discount.DISCOUNT_TYPE_CUSTOM_AMOUNT:
                showCustomAmountDialog(discount, false);
                break;
            case Discount.DISCOUNT_TYPE_KEYBOARD:
                showKeyboardDialog(discount, false);
                break;
//            case Discount.DISCOUNT_TYPE_FREE_SERVICE_CHARGE:
//
//                break;
            default:
                mListener.preformAddDiscount(discount.clone());
                break;
        }
    }

    private void exclusiveDiscount(Discount discount) {
        if (mListener != null) {
            showExclusiveTipDialog(discount);
        }
    }

    /**
     * 是否有獨佔折扣
     *
     * @return
     */
    private boolean hasExclusiveDiscount() {
        for (NomalDiscount nomalDiscount : mNomalDiscountList) {
            if (nomalDiscount.getDiscount().getExclusive() == 1) {
                return true;
            }
        }
        return false;
    }

    /**
     * 此折扣是否只一次
     *
     * @param discount
     * @return
     */
    private boolean isOnlyOnce(Discount discount) {
        if (discount.getOnlyOnce() == 1) {
            for (NomalDiscount nomalDiscount : mNomalDiscountList) {
                Discount item = nomalDiscount.getDiscount();
                if (discount.getId().longValue() == item.getId().longValue()) {
                    return true;
                }
            }
        }
        return false;
    }


    /**
     * 顯示自定義金額彈窗
     *
     * @param discount
     */
    private void showCustomAmountDialog(Discount discount, boolean exclusiveReplace) {
        CommonTipDialog.showEditDialog(mContext, discount.getRemark(), "請輸入折扣金額", InputType.TYPE_CLASS_NUMBER | InputType.TYPE_NUMBER_FLAG_DECIMAL, new CommonTipDialog.OnEditTextListener() {
            @Override
            public void inputText(String text) {
                discount.setAmount(Double.parseDouble(text));
                if (mListener != null) {
                    if (exclusiveReplace) {
                        mListener.exclusiveRemoveOthers(mNomalDiscountList);
                    }
                    mListener.preformAddDiscount(discount.clone());
                }
            }
        });
    }

    /**
     * 顯示子弟你金額彈窗 鍵盤
     *
     * @param discount
     */
    private void showKeyboardDialog(Discount discount, boolean exclusiveReplace) {
        new KeyboardDialog(mContext)
                .build()
                .setOnCallBackListener(new KeyboardDialog.OnCallBackListener() {
                    @Override
                    public void onSure(String number) {
                        discount.setAmount(Double.parseDouble(number));
                        if (mListener != null) {
                            if (exclusiveReplace) {
                                mListener.exclusiveRemoveOthers(mNomalDiscountList);
                            }
                            mListener.preformAddDiscount(discount.clone());
                        }
                    }
                })
                .show();
    }

    /**
     * 提示有獨佔折扣是否替換
     *
     * @param discount
     */
    private void showExclusiveTipDialog(Discount discount) {
        CommonTipDialog.showDoubtDialog2(mContext, "有獨佔折扣,是否替換", new CommonTipDialog.OnCallbackListener() {
            @Override
            public void onSure() {
                switch (discount.getType()) {
                    case Discount.DISCOUNT_TYPE_CUSTOM_AMOUNT:
                        showCustomAmountDialog(discount, true);
                        break;
                    case Discount.DISCOUNT_TYPE_KEYBOARD:
                        showKeyboardDialog(discount, true);
                        break;
//                    case Discount.DISCOUNT_TYPE_FREE_SERVICE_CHARGE:
//
//                        break;
                    default:
                        mListener.exclusiveRemoveOthers(mNomalDiscountList);
                        mListener.preformAddDiscount(discount.clone());
                        break;
                }
            }
        });
    }

    public interface OnCallBackListener {

        void exclusiveRemoveOthers(List<NomalDiscount> nomalDiscountList);

        void preformAddDiscount(Discount discount);
    }

}
