package com.gingersoft.gsa.delivery_pick_mode.ui.activity

import android.app.Dialog
import android.os.Bundle
import android.widget.TextView
import androidx.core.content.ContextCompat
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import com.gingersoft.gsa.cloud.common.core.delivery.OrderDetails
import com.gingersoft.gsa.cloud.common.core.delivery.OrderDetails.DataBean
import com.gingersoft.gsa.cloud.common.core.restaurant.ResturantInfoManager
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil
import com.gingersoft.gsa.cloud.common.utils.toast.ToastUtils
import com.gingersoft.gsa.cloud.pay.bean.PayMethod
import com.gingersoft.gsa.cloud.ui.utils.DialogUtils
import com.gingersoft.gsa.delivery_pick_mode.R
import com.gingersoft.gsa.delivery_pick_mode.data.model.bean.BillBean
import com.gingersoft.gsa.delivery_pick_mode.model.viewModel.PageViewModel
import com.gingersoft.gsa.delivery_pick_mode.ui.adapter.FoodListAdapter
import com.gingersoft.gsa.delivery_pick_mode.ui.adapter.PayBillAdapter
import com.gingersoft.gsa.delivery_pick_mode.ui.base.BaseActivity
import com.gingersoft.gsa.delivery_pick_mode.util.InjectorUtil
import com.jess.arms.mvp.IPresenter
import kotlinx.android.synthetic.main.activity_pay.*

class PayActivity : BaseActivity<IPresenter>() {

    private lateinit var pageViewModel: PageViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_pay)

        qm_order_pay_bar.setTitle("結賬")
        qm_order_pay_bar.addLeftImageButton(R.drawable.icon_return, R.id.iv_left_back).setOnClickListener { finish() }
        qm_order_pay_bar.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color))

        val orderDetails: DataBean = intent.getSerializableExtra("orderDetails") as DataBean

        pageViewModel = ViewModelProvider(this, InjectorUtil.getWeatherModelFactory())[PageViewModel::class.java]

        var foodCount = 0
        orderDetails.PRODUCT_NAME?.let { it ->
            rv_order_pay_food.layoutManager = LinearLayoutManager(this)
            rv_order_pay_food.adapter = FoodListAdapter(this, it)
            for (bean in it) {
                bean.child?.let { it ->
                    for (child in it) {
                        child.child?.let {
                            for (childBean in it) {
                                foodCount += childBean.num!!.toInt()
                            }
                        }
                        foodCount += child.num!!.toInt()
                    }
                }
                foodCount += bean.num!!.toInt()
            }
        }
        var totalAmount = orderDetails.TOTAL_AMOUNT!!.toDouble()
        orderDetails.couponList?.let {
            for (coupon in it){
                totalAmount = MoneyUtil.sub(totalAmount, coupon.discount_amount)
            }
        }
        other_pay_view.loadInfo(this, ArrayList<PayMethod>(), totalAmount, foodCount)

        pageViewModel.getPayMethod(ResturantInfoManager.newInstance().getBrandId(), ResturantInfoManager.newInstance().getRestaurantId())
        pageViewModel.payTypeBean.observe(this, Observer {
            //獲取支付方式
//            other_pay_view.loadInfo(this, PayTypeInfo.getPayMethodByPayType(it), MoneyUtil.sub(orderDetails.TOTAL_AMOUNT!!.toDouble(), orderDetails.discount_amount), foodCount)
            if (it == null) {
                ToastUtils.show(this@PayActivity, "查詢支付方式失敗")
            } else {
                other_pay_view.notifyBillMethodAdapter(it)
            }
        })

        other_pay_view.setmOnSureClickLisenter { payMethods ->
            //確認結賬，調用結賬接口
            object : DialogUtils(this, R.layout.other_order_pause_orders) {
                override fun initLayout(hepler: ViewHepler, dialog: Dialog) {
                    hepler.setText(R.id.tv_warning_title, "是否確認結賬？")
                    hepler.getView<TextView>(R.id.tv_dialog_confirm).setOnClickListener {
                        dialog.dismiss()
                        showLoading()
                        if (OrderDetails.verificationAmount(orderDetails)) {
                            ToastUtils.show(this@PayActivity, "訂單金額不正確，請檢查")
                            return@setOnClickListener
                        }
                        pageViewModel.closingBill(orderDetails, payMethods) { _, _ ->
                            cancelDialogForLoading()
                            setResult(RESULT_OK)
                            finish()

                        }
//                        pageViewModel.gsUpdateOrderStatus(orderDetails, payMethods[0].id, payMethods[0].name) { _, _ ->
//                            cancelDialogForLoading()
//                            setResult(RESULT_OK)
//                            finish()
//                        }
                    }
                    hepler.getView<TextView>(R.id.tv_dialog_cancel).setOnClickListener {
                        dialog.dismiss()
                    }
                }
            }.show()
        }


        val billBeans = ArrayList<BillBean>()
        billBeans.add(BillBean("合計：", MoneyUtil.sub(MoneyUtil.sub(orderDetails.TOTAL_AMOUNT!!.toDouble(), orderDetails.Lunchbox), orderDetails.DELIVERY_CHARGE)))
        if (orderDetails.Lunchbox > 0) {
            billBeans.add(BillBean("餐盒費：", orderDetails.Lunchbox))
        }
        if (orderDetails.DELIVERY_CHARGE > 0) {
            billBeans.add(BillBean("送貨費：", orderDetails.DELIVERY_CHARGE))
        }
        orderDetails.couponList?.let {
            for (coupon in it){
                billBeans.add(BillBean(coupon.couponName+"：", coupon.discount_amount, 1))
            }
        }
        billBeans.add(BillBean("支付金額：", totalAmount))
        rv_order_pay_bill.layoutManager = LinearLayoutManager(this)
        rv_order_pay_bill.adapter = PayBillAdapter(R.layout.item_pay_bill, billBeans)
    }


}