package com.gingersoft.gsa.cloud.pay.pos.hywebpos.imp;

import android.app.Activity;
import android.content.Context;

import com.gingersoft.gsa.cloud.common.constans.HttpsConstans;
import com.gingersoft.gsa.cloud.common.utils.okhttpUtils.OkHttp3Utils;
import com.gingersoft.gsa.cloud.pay.pos.IPosAction;
import com.gingersoft.gsa.cloud.pay.pos.PosAction;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.HywebPosResponse;
import com.jess.arms.mvp.IView;

import javax.inject.Inject;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;

/**
 * @作者: bin
 * @創建時間: 2020-12-26 10:38
 * @更新時間: 2020-12-26 10:38
 * @描述:
 */
public class SettlementActionImpl extends IPosAction {

    @Inject
    RxErrorHandler mErrorHandler;

    public SettlementActionImpl(Context context, IView iView, PosAction action, boolean showLoading) {
        super(context,iView,action,showLoading);
    }

    @Override
    protected void onRequestBefore() {
        OkHttp3Utils.post(HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL + "posPay/getRefundTxnId", null)
                .subscribeOn(Schedulers.io())
                .observeOn(Schedulers.io())
                .doOnSubscribe(disposable -> {

                })
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new ErrorHandleSubscriber<String>(mErrorHandler) {

                    @Override
                    public void onNext(String s) {

                    }
                });
    }

    @Override
    public void onRequestPOS(String requestJson) {
        super.onRequestPOS(requestJson);
    }

    @Override
    public void onActionComplte(Context context,HywebPosResponse result, Activity actionActivity) {

    }

    @Override
    public void onActionError(Exception error) {

    }
}
