package com.gingersoft.gsa.cloud.ui.utils;

import android.app.Dialog;
import android.content.Context;
import android.view.Gravity;
import android.view.View;
import android.view.WindowManager;

import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.adapter.RadioListAdapter;
import com.jess.arms.utils.ArmsUtils;

import java.util.List;

public class AppDialog {

    private static AppDialog appDialog;

    public static AppDialog getInstance() {
        if (appDialog == null) {
            appDialog = new AppDialog();
        }
        return appDialog;
    }


    public void showWaringDialog(Context context, String title, DialogOnClickListenter sureOnclickListenter) {
        showWaringDialog(context, title, null, null, sureOnclickListenter, null);
    }

    public void showWaringDialog(Context context, String title, DialogOnClickListenter sureOnclickListenter, DialogOnClickListenter cancelOnclickListenter) {
        showWaringDialog(context, title, null, null, sureOnclickListenter, cancelOnclickListenter);
    }

    private void showWaringDialog(Context context, String title, String confimText, String cancelText, DialogOnClickListenter sureOnclickListenter, DialogOnClickListenter cancelOnclickListenter) {
        new DialogUtils(context, R.layout.other_order_pause_orders) {
            @Override
            public void initLayout(ViewHepler hepler, Dialog dialog) {
                if (title != null)
                    hepler.setText(R.id.tv_warning_title, title);
                if (confimText != null)
                    hepler.setText(R.id.tv_dialog_confirm, confimText);
                if (sureOnclickListenter != null) {
                    hepler.getView(R.id.tv_dialog_confirm).setOnClickListener(v -> sureOnclickListenter.onclick(v, dialog));
                }
                if (cancelText != null)
                    hepler.setText(R.id.tv_dialog_cancel, cancelText);
                if (cancelOnclickListenter != null)
                    hepler.getView(R.id.tv_dialog_cancel).setOnClickListener(v -> cancelOnclickListenter.onclick(v, dialog));
                else
                    hepler.getView(R.id.tv_dialog_cancel).setOnClickListener(v -> dialog.dismiss());
            }
        }.show();
    }

    public void showSelectDialog(Context context, String title, int spanCount, RecyclerView.Adapter adapter, DialogOnClickListenter sureOnclickListenter) {
        new DialogUtils(context, R.layout.dialog_select_layout) {
            @Override
            public void initLayout(ViewHepler hepler, Dialog dialog) {
                hepler.setText(R.id.tv_title, title);
                hepler.setAdapter(R.id.rv_delivery, new GridLayoutManager(context, spanCount), adapter);
                hepler.setOnClickListenter(R.id.tv_delivery_confirm, v -> sureOnclickListenter.onclick(v, dialog));
                hepler.setOnClickListenter(R.id.tv_delivery_cancel, v -> sureOnclickListenter.onclick(v, dialog));
            }
        }
                .setWidth(WindowManager.LayoutParams.MATCH_PARENT)
                .setHeight((int) (ArmsUtils.getScreenHeidth(context) * 0.5))
                .setGravity(Gravity.BOTTOM)
                .show();
    }

    public void showSelectDialog(Context context, String title, List<String> list, int defaultCheck, onDialogSelectListener onDialogSelectListener) {
        RadioListAdapter radioListAdapter = new RadioListAdapter(list);
        radioListAdapter.setSelectIndex(defaultCheck);
        showSelectDialog(context, title, 1, radioListAdapter, (view, dialog) -> {
            if (onDialogSelectListener != null) {
                onDialogSelectListener.onclick(view, dialog, radioListAdapter.getSelectIndex());
            }
        });
    }

    public interface DialogOnClickListenter {
        void onclick(View view, Dialog dialog);
    }

    public interface onDialogSelectListener {
        void onclick(View view, Dialog dialog, int position);
    }

    public void showTipDialog(Context context, String title, DialogOnClickListenter sureOnclickListenter) {
        new DialogUtils(context, R.layout.dialog_tip) {
            @Override
            public void initLayout(ViewHepler hepler, Dialog dialog) {
                if (title != null) {
                    hepler.setText(R.id.tv_warning_title, title);
                }
                hepler.getView(R.id.tv_dialog_cancel).setOnClickListener(v -> dialog.dismiss());
                hepler.getView(R.id.tv_dialog_confirm).setOnClickListener(v -> {
                    if (sureOnclickListenter != null) {
                        sureOnclickListenter.onclick(v, dialog);
                    }
                });
            }
        }.show();
    }
}
