package com.joe.print.mvp.ui.view;

import android.content.Context;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.print.bean.base.PrintBillItem;
import com.joe.print.R;
import com.joe.print.mvp.model.bean.BillingBean;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/30
 * Time: 11:12
 * Use:結賬單和印單的賬單信息
 */
public class BillView extends LinearLayout {

    private List<BillingBean> data;

    public BillView(Context context, List<BillingBean> data) {
        super(context);
        this.data = data;
        setOrientation(LinearLayout.VERTICAL);
        init();
    }

    private void init() {
        for (BillingBean item : data) {
            View view = View.inflate(getContext(), R.layout.base_print_bill_adapter_item_bill, null);
            TextView tvBillTotalText = view.findViewById(R.id.tv_bill_total_text);
            TextView tvBillTotal = view.findViewById(R.id.tv_bill_total);
            tvBillTotalText.setText(item.getOptionName());
            if (item.getTotalAmount() < 0) {
                tvBillTotal.setText("-$" + Math.abs(item.getTotalAmount()));
            } else if (item.getTotalAmount() > 0) {
                tvBillTotal.setText("$" + item.getTotalAmount());
            }
            addView(view);
        }
    }
}