package com.gingersoft.gsa.cloud.database.utils;

import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import android.util.Log;
import com.gingersoft.gsa.cloud.database.DaoManager;
import com.gingersoft.gsa.cloud.database.bean.Language;
import com.gingersoft.gsa.cloud.database.greendao.LanguageDao;
import org.greenrobot.greendao.query.QueryBuilder;
import java.util.ArrayList;
import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-02
 * 修订历史：2020-01-02
 * 描述：
 */
public class LanguageDaoUtils {

    private static final String TAG = LanguageDaoUtils.class.getSimpleName();
    private DaoManager mManager;
    private Context mContext;

    public LanguageDaoUtils(Context context) {
        mManager = DaoManager.getInstance();
        mManager.init(context);
        this.mContext = context;
    }

    /**
     * 清除緩存
     */
    public void detachAll() {
        LanguageDao languageDao = DaoManager.getInstance().getDaoSession().getLanguageDao();
        languageDao.detachAll();
    }


    /**
     * 完成Food记录的插入，如果表未创建，先创建Food表
     *
     * @param language
     * @return
     */
    public boolean insertLanguage(Language language) {
        boolean flag = false;
        flag = mManager.getDaoSession().getLanguageDao().insert(language) == -1 ? false : true;
        Log.i(TAG, "insert LanguageItem :" + flag + "-->" + language.toString());
        return flag;
    }

    /**
     * 插入多条数据，在子线程操作
     *
     * @param foodList
     * @return
     */
    public boolean insertMultLanguage(final List<Language> foodList) {
        boolean flag = false;
        try {
            mManager.getDaoSession().runInTx(new Runnable() {
                @Override
                public void run() {
                    for (Language Food : foodList) {
                        mManager.getDaoSession().insertOrReplace(Food);
                    }
                }
            });
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 修改一条数据
     *
     * @param Language
     * @return
     */
    public boolean updateLanguage(Language Language) {
        boolean flag = false;
        try {
            mManager.getDaoSession().update(Language);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除单条记录
     *
     * @param food
     * @return
     */
    public boolean deleteLanguage(Language food) {
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().delete(food);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除所有记录
     *
     * @return
     */
    public boolean deleteAll() {
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().deleteAll(Language.class);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 查询所有记录
     *
     * @return
     */
    public List<Language> queryAllLanguage() {
        return mManager.getDaoSession().loadAll(Language.class);
    }

    /**
     * 根据主键id查询记录
     *
     * @param key
     * @return
     */
    public Language queryLanguageById(long key) {
        return mManager.getDaoSession().load(Language.class, key);
    }

    /**
     * 使用native sql进行查询操作
     */
    public List<Language> queryLanguageByNativeSql(String sql, String[] conditions) {
        return mManager.getDaoSession().queryRaw(Language.class, sql, conditions);
    }

}
