/*
 * Decompiled with CFR 0.152.
 */
package com.epson.eposdevice.display;

import com.epson.eposdevice.EposException;
import com.epson.eposdevice.display.NativeDisplay;
import com.epson.eposdevice.display.ReceiveListener;

public abstract class Display
extends NativeDisplay {
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int SCROLL_OVERWRITE = 0;
    public static final int SCROLL_VERTICAL = 1;
    public static final int SCROLL_HORIZONTAL = 2;
    public static final int MOVE_TOP_LEFT = 0;
    public static final int MOVE_TOP_RIGHT = 1;
    public static final int MOVE_BOTTOM_LEFT = 2;
    public static final int MOVE_BOTTOM_RIGHT = 3;
    public static final int CURSOR_NONE = 0;
    public static final int CURSOR_UNDERLINE = 1;
    public static final int LANG_EN = 0;
    public static final int LANG_JA = 1;
    public static final int MARQUEE_WALK = 0;
    public static final int MARQUEE_PLACE = 1;
    public static final int BRIGHTNESS_20 = 0;
    public static final int BRIGHTNESS_40 = 1;
    public static final int BRIGHTNESS_60 = 2;
    public static final int BRIGHTNESS_100 = 3;
    private ReceiveListener mReciveListener = null;
    private long mDspHandle = 0L;

    private void OnDspReceive(String ipAddress, String deviceId, int success, int code) {
        if (null != this.mReciveListener) {
            this.outputLogEvent("onDspReceive", ipAddress, deviceId, success, code);
            this.mReciveListener.onDspReceive(ipAddress, deviceId, success, code);
        }
    }

    protected Display(long dspHandle) {
        this.mDspHandle = dspHandle;
    }

    protected long getInnerHandle() {
        return this.mDspHandle;
    }

    protected void innerDeleteInstance() {
        this.nativeSetDspReceiveCallback(this.mDspHandle, null);
        this.mDspHandle = 0L;
    }

    protected void checkHandle() throws EposException {
        if (this.mDspHandle == 0L) {
            throw new EposException(255);
        }
    }

    public void sendData() throws EposException {
        this.outputLogCallFunction("sendData", new Object[0]);
        try {
            this.checkHandle();
            int result = this.nativeDspSendData(this.mDspHandle);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("sendData", ex);
            throw ex;
        }
        this.outputLogReturnFunction("sendData", new Object[0]);
    }

    public void clearCommandBuffer() {
        this.outputLogCallFunction("clearCommandBuffer", new Object[0]);
        if (this.mDspHandle != 0L) {
            this.nativeDspClearCommandBuffer(this.mDspHandle);
        }
        this.outputLogReturnFunction("clearCommandBuffer", new Object[0]);
    }

    public void reset() throws EposException {
        this.outputLogCallFunction("reset", new Object[0]);
        try {
            this.checkHandle();
            int result = this.nativeDspAddReset(this.mDspHandle);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("reset", ex);
            throw ex;
        }
        this.outputLogReturnFunction("reset", new Object[0]);
    }

    public void createWindow(int number, int x, int y, int width, int height, int scrollMode) throws EposException {
        this.outputLogCallFunction("createWindow", number, x, y, width, height, scrollMode);
        try {
            this.checkHandle();
            int result = this.nativeDspAddCreateWindow(this.mDspHandle, number, x, y, width, height, scrollMode);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("createWindow", ex);
            throw ex;
        }
        this.outputLogReturnFunction("createWindow", number, x, y, width, height, scrollMode);
    }

    public void destroyWindow(int number) throws EposException {
        this.outputLogCallFunction("destroyWindow", number);
        try {
            this.checkHandle();
            int result = this.nativeDspAddDestroyWindow(this.mDspHandle, number);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("destroyWindow", ex);
            throw ex;
        }
        this.outputLogReturnFunction("destroyWindow", number);
    }

    public void setCurrentWindow(int number) throws EposException {
        this.outputLogCallFunction("setCurrentWindow", number);
        try {
            this.checkHandle();
            int result = this.nativeDspAddSetCurrentWindow(this.mDspHandle, number);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("setCurrentWindow", ex);
            throw ex;
        }
        this.outputLogReturnFunction("setCurrentWindow", number);
    }

    public void clearWindow() throws EposException {
        this.outputLogCallFunction("clearWindow", new Object[0]);
        try {
            this.checkHandle();
            int result = this.nativeDspAddClearWindow(this.mDspHandle);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("clearWindow", ex);
            throw ex;
        }
        this.outputLogReturnFunction("clearWindow", new Object[0]);
    }

    public void setCursorPosition(int x, int y) throws EposException {
        this.outputLogCallFunction("setCursorPosition", x, y);
        try {
            this.checkHandle();
            int result = this.nativeDspAddSetCursorPosition(this.mDspHandle, x, y);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("setCursorPosition", ex);
            throw ex;
        }
        this.outputLogReturnFunction("setCursorPosition", x, y);
    }

    public void moveCursorPosition(int position) throws EposException {
        this.outputLogCallFunction("moveCursorPosition", position);
        try {
            this.checkHandle();
            int result = this.nativeDspAddMoveCursorPosition(this.mDspHandle, position);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("moveCursorPosition", ex);
            throw ex;
        }
        this.outputLogReturnFunction("moveCursorPosition", position);
    }

    public void setCursorType(int type) throws EposException {
        this.outputLogCallFunction("setCursorType", type);
        try {
            this.checkHandle();
            int result = this.nativeDspAddSetCursorType(this.mDspHandle, type);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("setCursorType", ex);
            throw ex;
        }
        this.outputLogReturnFunction("setCursorType", type);
    }

    public void addText(String data) throws EposException {
        this.outputLogCallFunction("addText", data);
        try {
            this.checkHandle();
            int result = this.nativeDspAddText(this.mDspHandle, data);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("addText", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addText", data);
    }

    public void addText(String data, int lang) throws EposException {
        this.outputLogCallFunction("addText", data, lang);
        try {
            this.checkHandle();
            int result = this.nativeDspAddTextLang(this.mDspHandle, data, lang);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("addText", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addText", data, lang);
    }

    public void addText(String data, int x, int y) throws EposException {
        this.outputLogCallFunction("addText", data, x, y);
        try {
            this.checkHandle();
            int result = this.nativeDspAddTextPosition(this.mDspHandle, data, x, y);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("addText", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addText", data, x, y);
    }

    public void addText(String data, int x, int y, int lang) throws EposException {
        this.outputLogCallFunction("addText", data, x, y, lang);
        try {
            this.checkHandle();
            int result = this.nativeDspAddTextPositionLang(this.mDspHandle, data, x, y, lang);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("addText", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addText", data, x, y, lang);
    }

    public void addReverseText(String data) throws EposException {
        this.outputLogCallFunction("addReverseText", data);
        try {
            this.checkHandle();
            int result = this.nativeDspAddReverseText(this.mDspHandle, data);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("addReverseText", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addReverseText", data);
    }

    public void addReverseText(String data, int lang) throws EposException {
        this.outputLogCallFunction("addReverseText", data, lang);
        try {
            this.checkHandle();
            int result = this.nativeDspAddReverseTextLang(this.mDspHandle, data, lang);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("addReverseText", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addReverseText", data, lang);
    }

    public void addReverseText(String data, int x, int y) throws EposException {
        this.outputLogCallFunction("addReverseText", data, x, y);
        try {
            this.checkHandle();
            int result = this.nativeDspAddReverseTextPosition(this.mDspHandle, data, x, y);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("addReverseText", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addReverseText", data, x, y);
    }

    public void addReverseText(String data, int x, int y, int lang) throws EposException {
        this.outputLogCallFunction("addReverseText", data, x, y, lang);
        try {
            this.checkHandle();
            int result = this.nativeDspAddReverseTextPositionLang(this.mDspHandle, data, x, y, lang);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("addReverseText", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addReverseText", data, x, y, lang);
    }

    public void addMarquee(String data, int format, int unitWait, int repeatWait, int repeatCount, int lang) throws EposException {
        this.outputLogCallFunction("addMarquee", data, format, unitWait, repeatWait, repeatCount, lang);
        try {
            this.checkHandle();
            int result = this.nativeDspAddMarquee(this.mDspHandle, data, format, unitWait, repeatWait, repeatCount, lang);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("addMarquee", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addMarquee", data, format, unitWait, repeatWait, repeatCount, lang);
    }

    public void setBlink(int interval) throws EposException {
        this.outputLogCallFunction("setBlink", interval);
        try {
            this.checkHandle();
            int result = this.nativeDspAddBlink(this.mDspHandle, interval);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("setBlink", ex);
            throw ex;
        }
        this.outputLogReturnFunction("setBlink", interval);
    }

    public void setBrightness(int brightness) throws EposException {
        this.outputLogCallFunction("setBrightness", brightness);
        try {
            this.checkHandle();
            int result = this.nativeDspAddBrightness(this.mDspHandle, brightness);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("setBrightness", ex);
            throw ex;
        }
        this.outputLogReturnFunction("setBrightness", brightness);
    }

    public void showClock() throws EposException {
        this.outputLogCallFunction("showClock", new Object[0]);
        try {
            this.checkHandle();
            int result = this.nativeDspAddShowClock(this.mDspHandle);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("showClock", ex);
            throw ex;
        }
        this.outputLogReturnFunction("showClock", new Object[0]);
    }

    public void addCommand(byte[] data) throws EposException {
        this.outputLogCallFunction("addCommand", new Object[]{data});
        try {
            this.checkHandle();
            int result = this.nativeDspAddCommand(this.mDspHandle, data);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("addCommand", ex);
            throw ex;
        }
        this.outputLogReturnFunction("addCommand", new Object[]{data});
    }

    public void setReceiveEventCallback(ReceiveListener target) {
        if (this.mDspHandle != 0L) {
            if (target != null) {
                this.mReciveListener = target;
                this.nativeSetDspReceiveCallback(this.mDspHandle, this);
            } else {
                this.nativeSetDspReceiveCallback(this.mDspHandle, null);
                this.mReciveListener = null;
            }
        }
    }

    @Override
    protected void nativeOnDspReceive(String ipAddress, String deviceId, int success, int code, long status, long battery) {
        this.OnDspReceive(ipAddress, deviceId, success, code);
    }

    protected abstract void outputLogCallFunction(String var1, Object ... var2);

    protected abstract void outputLogReturnFunction(String var1, Object ... var2);

    protected abstract void outputException(String var1, Exception var2);

    protected abstract void outputLogEvent(String var1, Object ... var2);
}

