package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.Gravity;
import android.widget.LinearLayout;
import com.gingersoft.gsa.cloud.base.common.bean.BillingBean;
import com.gingersoft.gsa.cloud.base.order.bean.BillOrderMoney;
import com.gingersoft.gsa.cloud.base.order.bean.OrderDetail;
import com.gingersoft.gsa.cloud.base.order.bean.mealManger.MyOrderManage;
import com.gingersoft.gsa.cloud.base.order.bean.mealManger.OpenTableManage;
import com.gingersoft.gsa.cloud.base.table.bean.TableBean;
import com.gingersoft.gsa.cloud.base.utils.RestaurantExpandInfoUtils;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.constans.ExpandConstant;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.joe.print.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 印單打印  已改新版
 */
public class PrintSlip extends PrinterRoot {

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        List<Bitmap> bitmaps = new ArrayList<>();
        bitmaps.add(getBitmap(mContext, deviceBean));
        bitmapMaps.put("", bitmaps);
        //這裡可能還需要加上廚房單的內容，有未送單的食品時。
//        PrintKitchen kitchen = new PrintKitchen();
//        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>(kitchen.getPrintBitmap(mContext, deviceBean));
//        if (bitmapMaps.size() == 0) {
//            bitmapMaps.put("", bitmaps);
//        } else {
//            merge2ResultMap(bitmapMaps, "", bitmaps);
//        }
        return bitmapMaps;
    }

    @Override
    public int getPrintCount(Context context) {
        return RestaurantExpandInfoUtils.getValue(ExpandConstant.TableModePrintCount,1);
    }

    private Bitmap getBitmap(Context mContext, PrinterDeviceBean printerDeviceBean) {
        List<OrderDetail> foodList = MyOrderManage.getInstance().getOrderFoodList();
        if (foodList == null || foodList.size() <= 0) {
            return null;
        }
        TableBean.DataBean tableBean = OpenTableManage.getDefault().getTableBean();

        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);

        //訂單頭
        layout.addView(getHeader(mContext));
        layout.addView(getLine(mContext));

        //訂單信息
        String orderId = "";
        if (MyOrderManage.getInstance().getOrderId() != -1) {
            orderId = MyOrderManage.getInstance().getOrderId() + "";
        }
        layout.addView(getDiningTableOrderInfo(mContext, "餐檯：" + tableBean.getTableName(), "人數：" + OpenTableManage.getDefault().getPeopleNumber(), "單號：" + orderId, "日期：" + TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT)));
        layout.addView(getLine(mContext));

        layout.addView(getDiningFoodList(mContext, foodList, printerDeviceBean, 0, true));
        layout.addView(getHalfLine(mContext));
        List<BillingBean> billingBeans = new ArrayList<>();
        //添加合計項
        billingBeans.add(new BillingBean("合計", MyOrderManage.getInstance().getWholeAmount()));
        //添加其他金額項
        if (MyOrderManage.getInstance().getOrderMoneyList().size() > 0) {
            for (BillOrderMoney item : MyOrderManage.getInstance().getOrderMoneyList()) {
                billingBeans.add(new BillingBean(item.getTitle(), item.getMoney()));
            }
        }
        layout.addView(getDiningBillInfo(mContext, billingBeans));
        layout.addView(getHalfLine(mContext));
        layout.addView(getAmountText(mContext, "總金額：" + MyOrderManage.getInstance().getTotalAmount()));
        layout.addView(getLine(mContext));
        layout.addView(getTextView(mContext, "Thank you!", Gravity.CENTER_HORIZONTAL, getDimensionPixelSize(mContext, R.dimen.dp_8)));
        layout.addView(getTextView(mContext, TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT), Gravity.CENTER_HORIZONTAL, getDimensionPixelSize(mContext, R.dimen.dp_8)));
        return viewToZoomBitmap(mContext, layout, printerDeviceBean);
    }


}
