package com.joe.print.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.ViewPager;
import com.gingersoft.gsa.cloud.ui.adapter.TabFragmentAdapter;
import com.gingersoft.gsa.cloud.ui.view.MyTableView;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.joe.print.R;
import com.joe.print.R2;
import com.joe.print.di.component.DaggerPrintListComponent;
import com.joe.print.mvp.contract.PrintListContract;
import com.joe.print.mvp.presenter.PrintListPresenter;
import com.joe.print.mvp.print.PrintUtils;
import com.joe.print.mvp.ui.fragment.IpPrintListActivityFragment;
import com.joe.print.mvp.ui.fragment.LocalPrintFragment;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/16/2020 10:24
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class PrinterListActivity extends BaseFragmentActivity<PrintListPresenter> implements PrintListContract.View {

    @BindView(R2.id.printer_home_bar)
    QMUITopBar topBar;

    @BindView(R2.id.print_table_layout)
    MyTableView mTabLayout;
    @BindView(R2.id.print_viewpager)
    ViewPager mViewPager;


    private TabFragmentAdapter mTabFragmentAdapter;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerPrintListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.printer_activity_list; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        initViewPager();
    }

    private IpPrintListActivityFragment ipPrintListActivityFragment;

    /**
     * 設置Viewpager的适配器
     */
    private void initViewPager() {
        List<String> titles = new ArrayList<>();
        List<Fragment> mFragments = new ArrayList<>();
//        if (PrintUtils.isPrintDevice()) {
        titles.add("通用打印設定");
        mFragments.add(LocalPrintFragment.newInstance());
//        }
        titles.add("打印機設定");
        ipPrintListActivityFragment = IpPrintListActivityFragment.newInstance();
        mFragments.add(ipPrintListActivityFragment);

        //实例化适配器
        mTabFragmentAdapter = new TabFragmentAdapter(getSupportFragmentManager(), 1);
        //设置加载的Fragment集合
        mTabFragmentAdapter.setFragments(mFragments);
        //设置Viewpager的适配器
        mViewPager.setAdapter(mTabFragmentAdapter);

        mTabLayout.setTitles(titles).setupWithViewPager(mViewPager);//TabLayout绑定ViewPager
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
        topBar.setTitle("打印設置");
        topBar.setBackgroundColor(getResources().getColor(R.color.theme_color));
        topBar.addLeftImageButton(R.drawable.icon_return, R.id.iv_left_back).setOnClickListener(v -> finish());
        topBar.addRightImageButton(R.drawable.ic_add, R.id.printer_add).setOnClickListener(v -> {
            if (mViewPager.getCurrentItem() == 0) {
                //添加通用打印
                startActivity(new Intent(this, PrintAddCurrencyActivity.class));
            } else {
                if (ipPrintListActivityFragment != null && ipPrintListActivityFragment.isAdded()) {
                    ipPrintListActivityFragment.startToEditPrint(-1);
                }
            }
        });
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(mContext, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }


}
