package com.joe.print.mvp.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.database.bean.PrintCurrencyBean;
import com.gingersoft.gsa.cloud.database.utils.PrintCurrencyDaoUtils;
import com.gingersoft.gsa.cloud.ui.utils.AppDialog;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.joe.print.R;
import com.joe.print.R2;
import com.joe.print.di.component.DaggerLocalPrintComponent;
import com.joe.print.di.module.LocalPrintModule;
import com.joe.print.mvp.contract.LocalPrintContract;
import com.joe.print.mvp.presenter.LocalPrintPresenter;
import com.joe.print.mvp.ui.activity.PrintAddCurrencyActivity;

import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;

/**
 * 本機打印配置頁
 */
public class LocalPrintFragment extends BaseFragment<LocalPrintPresenter> implements LocalPrintContract.View {
    @BindView(R2.id.layout_currency_content)
    LinearLayout currencyContent;

    public static LocalPrintFragment newInstance() {
        LocalPrintFragment fragment = new LocalPrintFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerLocalPrintComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .localPrintModule(new LocalPrintModule(this))
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_local_print, container, false);
    }

    @Override
    public void onResume() {
        super.onResume();
        mPresenter.getPrinterCurrencyList(GsaCloudApplication.getRestaurantId());
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
//        mLayoutLocationPrint.setVisibility(PrintUtils.isPrintDevice() ? View.VISIBLE : View.GONE);
//        ivSetLocationPrintBtn.setOnCheckedChangeListener((buttonView, isChecked) -> {
//            if (isChecked) {
//                //修改默認打印方式為本地
//                SPUtils.put(mContext, PrintConstans.DEFAULT_PRINT_METHOD, PrintConstans.LOCAL_PRINT);
//                ivSetLocationPrintBtn.setChecked(true);
//            } else {
//                //如果默認打印方式為IP，修改為IP打印
//                SPUtils.put(mContext, PrintConstans.DEFAULT_PRINT_METHOD, PrintConstans.IP_PRINT);
//                ivSetLocationPrintBtn.setChecked(false);
//            }
//        });
    }

    /**
     * 通过此方法可以使 Fragment 能够与外界做一些交互和通信, 比如说外部的 Activity 想让自己持有的某个 Fragment 对象执行一些方法,
     * 建议在有多个需要与外界交互的方法时, 统一传 {@link Message}, 通过 what 字段来区分不同的方法, 在 {@link #setData(Object)}
     * 方法中就可以 {@code switch} 做不同的操作, 这样就可以用统一的入口方法做多个不同的操作, 可以起到分发的作用
     * <p>
     * 调用此方法时请注意调用时 Fragment 的生命周期, 如果调用 {@link #setData(Object)} 方法时 {@link (Bundle)} 还没执行
     * 但在 {@link #setData(Object)} 里却调用了 Presenter 的方法, 是会报空的, 因为 Dagger 注入是在 {@link (Bundle)} 方法中执行的
     * 然后才创建的 Presenter, 如果要做一些初始化操作,可以不必让外部调用 {@link #setData(Object)}, 在 {@link #initData(Bundle)} 中初始化就可以了
     * <p>
     * Example usage:
     * <pre>
     * public void setData(@Nullable Object data) {
     *     if (data != null && data instanceof Message) {
     *         switch (((Message) data).what) {
     *             case 0:
     *                 loadData(((Message) data).arg1);
     *                 break;
     *             case 1:
     *                 refreshUI();
     *                 break;
     *             default:
     *                 //do something
     *                 break;
     *         }
     *     }
     * }
     *
     * // call setData(Object):
     * Message data = new Message();
     * data.what = 0;
     * data.arg1 = 1;
     * fragment.setData(data);
     * </pre>
     *
     * @param data 当不需要参数时 {@code data} 可以为 {@code null}
     */
    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {

    }

    @Override
    public void loadView(List<PrintCurrencyBean> printCurrencyBeans) {
        currencyContent.removeAllViews();

        PrintCurrencyDaoUtils printCurrencyDaoUtils = new PrintCurrencyDaoUtils(_mActivity);
        printCurrencyDaoUtils.deleteAll();
        if (printCurrencyBeans != null) {
            printCurrencyDaoUtils.insertMultPrintCurrencyBean(printCurrencyBeans);
        }

        if (printCurrencyBeans != null) {
            for (int i = 0; i < printCurrencyBeans.size(); i++) {
                View view = LayoutInflater.from(_mActivity).inflate(R.layout.print_currency_item, null);
                TextView tvType = view.findViewById(R.id.tv_currency_print_type);
                TextView tvFoodColor = view.findViewById(R.id.tv_currency_print_food_color);
                TextView tvFoodItemColor = view.findViewById(R.id.tv_currency_print_food_items_color);
                tvType.setText(printCurrencyBeans.get(i).getType() == 1 ? "堂食" : "外送");
                if (printCurrencyBeans.get(i).getFoodComplexion() == 0) {
                    tvFoodColor.setText("黑色");
                } else if (printCurrencyBeans.get(i).getFoodComplexion() == 1) {
                    tvFoodColor.setText("紅色");
                } else if (printCurrencyBeans.get(i).getFoodComplexion() == 3) {
                    tvFoodColor.setText("綠色");
                }
                tvFoodItemColor.setText(printCurrencyBeans.get(i).getModifierComplexion() == 0 ? "黑色" : "紅色");
                int finalI1 = i;
                view.findViewById(R.id.iv_currency_print_delete).setOnClickListener(v -> {
                    //刪除
                    new AppDialog().showWaringDialog(mContext, "是否確認刪除", (view1, dialog) -> {
                        //調用刪除接口
                        if (finalI1 < printCurrencyBeans.size()) {
                            printCurrencyBeans.get(finalI1).setDeletes(1);
                            mPresenter.deletePrinterCurrency(printCurrencyBeans.get(finalI1));
                            printCurrencyBeans.remove(finalI1);
                            loadView(printCurrencyBeans);
                        }
                        dialog.dismiss();
                    });

                });
                int finalI = i;
                view.setOnClickListener(v -> {
                    //編輯
                    Intent intent = new Intent(mContext, PrintAddCurrencyActivity.class);
                    intent.putExtra("printCurrencyBean", printCurrencyBeans.get(finalI));
                    startActivity(intent);
                });
                currencyContent.addView(view);
            }
        }
    }
}
