package com.gingersoft.gsa.cloud.common.core.print.bean.base;

import android.os.Parcel;
import android.os.Parcelable;

import lombok.Data;

/**
 * 賬單項打印實體
 */
@Data
public class PrintBillItem implements Parcelable {

    private String billName;
    private String billAmount;

    public PrintBillItem(String billName, String billAmount) {
        this.billName = billName;
        this.billAmount = billAmount;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.billName);
        dest.writeString(this.billAmount);
    }

    protected PrintBillItem(Parcel in) {
        this.billName = in.readString();
        this.billAmount = in.readString();
    }

    public static final Creator<PrintBillItem> CREATOR = new Creator<PrintBillItem>() {
        @Override
        public PrintBillItem createFromParcel(Parcel source) {
            return new PrintBillItem(source);
        }

        @Override
        public PrintBillItem[] newArray(int size) {
            return new PrintBillItem[size];
        }
    };
}
