package com.gingersoft.gsa.cloud.database.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.Discount;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "DISCOUNT".
*/
public class DiscountDao extends AbstractDao<Discount, Long> {

    public static final String TABLENAME = "DISCOUNT";

    /**
     * Properties of entity Discount.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property RestaurantId = new Property(1, int.class, "restaurantId", false, "RESTAURANT_ID");
        public final static Property Amount = new Property(2, double.class, "amount", false, "AMOUNT");
        public final static Property DiscountValue = new Property(3, int.class, "discountValue", false, "DISCOUNT_VALUE");
        public final static Property Type = new Property(4, int.class, "type", false, "TYPE");
        public final static Property DiscountType = new Property(5, String.class, "discountType", false, "DISCOUNT_TYPE");
        public final static Property Status = new Property(6, int.class, "status", false, "STATUS");
        public final static Property Remark = new Property(7, String.class, "remark", false, "REMARK");
        public final static Property FreeServiceCharge = new Property(8, byte.class, "freeServiceCharge", false, "FREE_SERVICE_CHARGE");
        public final static Property ManagerApproval = new Property(9, byte.class, "managerApproval", false, "MANAGER_APPROVAL");
        public final static Property Color = new Property(10, String.class, "color", false, "COLOR");
        public final static Property PlaceOrderType = new Property(11, String.class, "placeOrderType", false, "PLACE_ORDER_TYPE");
        public final static Property DiscountCap = new Property(12, double.class, "discountCap", false, "DISCOUNT_CAP");
        public final static Property SalesAmount = new Property(13, double.class, "salesAmount", false, "SALES_AMOUNT");
        public final static Property TaxFree = new Property(14, byte.class, "taxFree", false, "TAX_FREE");
        public final static Property Exclusive = new Property(15, byte.class, "exclusive", false, "EXCLUSIVE");
        public final static Property Pause = new Property(16, byte.class, "pause", false, "PAUSE");
        public final static Property AdditionalDiscount = new Property(17, byte.class, "additionalDiscount", false, "ADDITIONAL_DISCOUNT");
        public final static Property OnlyOnce = new Property(18, byte.class, "onlyOnce", false, "ONLY_ONCE");
        public final static Property MinBillAmount = new Property(19, double.class, "minBillAmount", false, "MIN_BILL_AMOUNT");
        public final static Property PointsDeduction = new Property(20, byte.class, "pointsDeduction", false, "POINTS_DEDUCTION");
        public final static Property WholeFreePoints = new Property(21, byte.class, "wholeFreePoints", false, "WHOLE_FREE_POINTS");
        public final static Property AmountTypeMin = new Property(22, byte.class, "amountTypeMin", false, "AMOUNT_TYPE_MIN");
        public final static Property BeginTime = new Property(23, String.class, "beginTime", false, "BEGIN_TIME");
        public final static Property EndTime = new Property(24, String.class, "endTime", false, "END_TIME");
    }


    public DiscountDao(DaoConfig config) {
        super(config);
    }
    
    public DiscountDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"DISCOUNT\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"RESTAURANT_ID\" INTEGER NOT NULL ," + // 1: restaurantId
                "\"AMOUNT\" REAL NOT NULL ," + // 2: amount
                "\"DISCOUNT_VALUE\" INTEGER NOT NULL ," + // 3: discountValue
                "\"TYPE\" INTEGER NOT NULL ," + // 4: type
                "\"DISCOUNT_TYPE\" TEXT," + // 5: discountType
                "\"STATUS\" INTEGER NOT NULL ," + // 6: status
                "\"REMARK\" TEXT," + // 7: remark
                "\"FREE_SERVICE_CHARGE\" INTEGER NOT NULL ," + // 8: freeServiceCharge
                "\"MANAGER_APPROVAL\" INTEGER NOT NULL ," + // 9: managerApproval
                "\"COLOR\" TEXT," + // 10: color
                "\"PLACE_ORDER_TYPE\" TEXT," + // 11: placeOrderType
                "\"DISCOUNT_CAP\" REAL NOT NULL ," + // 12: discountCap
                "\"SALES_AMOUNT\" REAL NOT NULL ," + // 13: salesAmount
                "\"TAX_FREE\" INTEGER NOT NULL ," + // 14: taxFree
                "\"EXCLUSIVE\" INTEGER NOT NULL ," + // 15: exclusive
                "\"PAUSE\" INTEGER NOT NULL ," + // 16: pause
                "\"ADDITIONAL_DISCOUNT\" INTEGER NOT NULL ," + // 17: additionalDiscount
                "\"ONLY_ONCE\" INTEGER NOT NULL ," + // 18: onlyOnce
                "\"MIN_BILL_AMOUNT\" REAL NOT NULL ," + // 19: minBillAmount
                "\"POINTS_DEDUCTION\" INTEGER NOT NULL ," + // 20: pointsDeduction
                "\"WHOLE_FREE_POINTS\" INTEGER NOT NULL ," + // 21: wholeFreePoints
                "\"AMOUNT_TYPE_MIN\" INTEGER NOT NULL ," + // 22: amountTypeMin
                "\"BEGIN_TIME\" TEXT," + // 23: beginTime
                "\"END_TIME\" TEXT);"); // 24: endTime
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"DISCOUNT\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, Discount entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getRestaurantId());
        stmt.bindDouble(3, entity.getAmount());
        stmt.bindLong(4, entity.getDiscountValue());
        stmt.bindLong(5, entity.getType());
 
        String discountType = entity.getDiscountType();
        if (discountType != null) {
            stmt.bindString(6, discountType);
        }
        stmt.bindLong(7, entity.getStatus());
 
        String remark = entity.getRemark();
        if (remark != null) {
            stmt.bindString(8, remark);
        }
        stmt.bindLong(9, entity.getFreeServiceCharge());
        stmt.bindLong(10, entity.getManagerApproval());
 
        String color = entity.getColor();
        if (color != null) {
            stmt.bindString(11, color);
        }
 
        String placeOrderType = entity.getPlaceOrderType();
        if (placeOrderType != null) {
            stmt.bindString(12, placeOrderType);
        }
        stmt.bindDouble(13, entity.getDiscountCap());
        stmt.bindDouble(14, entity.getSalesAmount());
        stmt.bindLong(15, entity.getTaxFree());
        stmt.bindLong(16, entity.getExclusive());
        stmt.bindLong(17, entity.getPause());
        stmt.bindLong(18, entity.getAdditionalDiscount());
        stmt.bindLong(19, entity.getOnlyOnce());
        stmt.bindDouble(20, entity.getMinBillAmount());
        stmt.bindLong(21, entity.getPointsDeduction());
        stmt.bindLong(22, entity.getWholeFreePoints());
        stmt.bindLong(23, entity.getAmountTypeMin());
 
        String beginTime = entity.getBeginTime();
        if (beginTime != null) {
            stmt.bindString(24, beginTime);
        }
 
        String endTime = entity.getEndTime();
        if (endTime != null) {
            stmt.bindString(25, endTime);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, Discount entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getRestaurantId());
        stmt.bindDouble(3, entity.getAmount());
        stmt.bindLong(4, entity.getDiscountValue());
        stmt.bindLong(5, entity.getType());
 
        String discountType = entity.getDiscountType();
        if (discountType != null) {
            stmt.bindString(6, discountType);
        }
        stmt.bindLong(7, entity.getStatus());
 
        String remark = entity.getRemark();
        if (remark != null) {
            stmt.bindString(8, remark);
        }
        stmt.bindLong(9, entity.getFreeServiceCharge());
        stmt.bindLong(10, entity.getManagerApproval());
 
        String color = entity.getColor();
        if (color != null) {
            stmt.bindString(11, color);
        }
 
        String placeOrderType = entity.getPlaceOrderType();
        if (placeOrderType != null) {
            stmt.bindString(12, placeOrderType);
        }
        stmt.bindDouble(13, entity.getDiscountCap());
        stmt.bindDouble(14, entity.getSalesAmount());
        stmt.bindLong(15, entity.getTaxFree());
        stmt.bindLong(16, entity.getExclusive());
        stmt.bindLong(17, entity.getPause());
        stmt.bindLong(18, entity.getAdditionalDiscount());
        stmt.bindLong(19, entity.getOnlyOnce());
        stmt.bindDouble(20, entity.getMinBillAmount());
        stmt.bindLong(21, entity.getPointsDeduction());
        stmt.bindLong(22, entity.getWholeFreePoints());
        stmt.bindLong(23, entity.getAmountTypeMin());
 
        String beginTime = entity.getBeginTime();
        if (beginTime != null) {
            stmt.bindString(24, beginTime);
        }
 
        String endTime = entity.getEndTime();
        if (endTime != null) {
            stmt.bindString(25, endTime);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public Discount readEntity(Cursor cursor, int offset) {
        Discount entity = new Discount( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.getInt(offset + 1), // restaurantId
            cursor.getDouble(offset + 2), // amount
            cursor.getInt(offset + 3), // discountValue
            cursor.getInt(offset + 4), // type
            cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5), // discountType
            cursor.getInt(offset + 6), // status
            cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7), // remark
            (byte) cursor.getShort(offset + 8), // freeServiceCharge
            (byte) cursor.getShort(offset + 9), // managerApproval
            cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10), // color
            cursor.isNull(offset + 11) ? null : cursor.getString(offset + 11), // placeOrderType
            cursor.getDouble(offset + 12), // discountCap
            cursor.getDouble(offset + 13), // salesAmount
            (byte) cursor.getShort(offset + 14), // taxFree
            (byte) cursor.getShort(offset + 15), // exclusive
            (byte) cursor.getShort(offset + 16), // pause
            (byte) cursor.getShort(offset + 17), // additionalDiscount
            (byte) cursor.getShort(offset + 18), // onlyOnce
            cursor.getDouble(offset + 19), // minBillAmount
            (byte) cursor.getShort(offset + 20), // pointsDeduction
            (byte) cursor.getShort(offset + 21), // wholeFreePoints
            (byte) cursor.getShort(offset + 22), // amountTypeMin
            cursor.isNull(offset + 23) ? null : cursor.getString(offset + 23), // beginTime
            cursor.isNull(offset + 24) ? null : cursor.getString(offset + 24) // endTime
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, Discount entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setRestaurantId(cursor.getInt(offset + 1));
        entity.setAmount(cursor.getDouble(offset + 2));
        entity.setDiscountValue(cursor.getInt(offset + 3));
        entity.setType(cursor.getInt(offset + 4));
        entity.setDiscountType(cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5));
        entity.setStatus(cursor.getInt(offset + 6));
        entity.setRemark(cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7));
        entity.setFreeServiceCharge((byte) cursor.getShort(offset + 8));
        entity.setManagerApproval((byte) cursor.getShort(offset + 9));
        entity.setColor(cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10));
        entity.setPlaceOrderType(cursor.isNull(offset + 11) ? null : cursor.getString(offset + 11));
        entity.setDiscountCap(cursor.getDouble(offset + 12));
        entity.setSalesAmount(cursor.getDouble(offset + 13));
        entity.setTaxFree((byte) cursor.getShort(offset + 14));
        entity.setExclusive((byte) cursor.getShort(offset + 15));
        entity.setPause((byte) cursor.getShort(offset + 16));
        entity.setAdditionalDiscount((byte) cursor.getShort(offset + 17));
        entity.setOnlyOnce((byte) cursor.getShort(offset + 18));
        entity.setMinBillAmount(cursor.getDouble(offset + 19));
        entity.setPointsDeduction((byte) cursor.getShort(offset + 20));
        entity.setWholeFreePoints((byte) cursor.getShort(offset + 21));
        entity.setAmountTypeMin((byte) cursor.getShort(offset + 22));
        entity.setBeginTime(cursor.isNull(offset + 23) ? null : cursor.getString(offset + 23));
        entity.setEndTime(cursor.isNull(offset + 24) ? null : cursor.getString(offset + 24));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(Discount entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(Discount entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(Discount entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
