package com.gingersoft.gsa.cloud.main.mvp.ui.activity;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;

import com.gingersoft.gsa.cloud.common.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.common.utils.view.QRCodeUtil;
import com.gingersoft.gsa.cloud.common.constans.HttpsConstans;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerErCodeComponent;
import com.gingersoft.gsa.cloud.main.di.module.ErCodeModule;
import com.gingersoft.gsa.cloud.main.mvp.contract.QrCodeContract;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.RestaurantQrBean;
import com.gingersoft.gsa.cloud.main.mvp.presenter.QrCodePresenter;
import com.gingersoft.gsa.cloud.common.ui.view.BannerViewPager;
import com.gingersoft.gsa.cloud.common.ui.widget.dialog.LoadingDialog;
import com.google.android.material.tabs.TabLayout;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;


public class RestaurantQrCodeActivity extends BaseActivity<QrCodePresenter> implements QrCodeContract.View {
    @BindView(R2.id.topbar_qr_code)
    QMUITopBar topBar;
    @BindView(R2.id.table_layout_qr_code)
    TabLayout tabLayout;
    @BindView(R2.id.vp_qr_code)
    BannerViewPager viewPager;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerErCodeComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .erCodeModule(new ErCodeModule(this))
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_er_code; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        mPresenter.getRestaurantQrCode();
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
        topBar.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color));
        topBar.addLeftBackImageButton().setOnClickListener(v -> killMyself());
        topBar.setTitle("二維碼");
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(this, message, true);
        else
            LoadingDialog.showDialogForLoading(this);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    private void initTab() {
        viewPager.initBanner(tabs, true, views)//开启3D画廊效果
                .addPageMargin(-20, 20)//参数1page之间的间距,参数2中间item距离边界的间距
                .finishConfig();//这句必须加
        viewPager.getmViewPager().setCurrentItem(0);
        tabLayout.setupWithViewPager(viewPager.getmViewPager());//TabLayout的标签从Adapter中获取
        //用来循环适配器中的视图总数
        for (int i = 0; i < tabs.size(); i++) {
            //获取每一个tab对象
            TabLayout.Tab tabAt = tabLayout.getTabAt(i);
            if (tabAt != null) {
                //将每一个条目设置我们自定义的视图
                tabAt.setCustomView(R.layout.layout_table_item);
                //默认选中第一个
                if (i == 0) {
                    // 设置第一个tab的TextView是被选择的样式
                    setSelectTab(tabAt, true);
                }
                //通过tab对象找到自定义视图的ID
                TextView textView = tabAt.getCustomView().findViewById(R.id.tv_tab);
                textView.setText(tabs.get(i));//设置tab上的文字
            }
        }
    }

    private void setSelectTab(TabLayout.Tab tabAt, boolean isSelected) {
        if (tabAt.getCustomView() != null) {
            TextView tab = tabAt.getCustomView().findViewById(R.id.tv_tab);
            tab.setSelected(isSelected);
            //设置选中标签的文字大小
            tab.setTextSize(TypedValue.COMPLEX_UNIT_PX, isSelected ? getResources().getDimensionPixelSize(R.dimen.sp_16) : getResources().getDimensionPixelSize(R.dimen.sp_14));
            tab.getPaint().setFakeBoldText(isSelected);
        }
    }

    private List<String> tabs;
    private List<View> views;

    @Override
    public void loadQrCode(RestaurantQrBean.DataBean dataBean) {
        tabs = new ArrayList<>();
        views = new ArrayList<>();
        if (dataBean.getZiquService() == 1) {
            tabs.add("自取");
            views.add(getQrCodeView("自取", dataBean.getZiquServiceUrl()));
        }

        if (dataBean.getCanpaiService() == 1) {
            tabs.add("餐牌");
            views.add(getQrCodeView("餐牌", dataBean.getCanpaiServiceUrl()));
        }

        if (dataBean.getMenuService() == 1) {
            tabs.add("外賣");
            views.add(getQrCodeView("外賣", dataBean.getMenuServiceUrl()));
        }

        if (dataBean.getFreezingService() == 1) {
            tabs.add("凍鏈");
            views.add(getQrCodeView("凍鏈", dataBean.getFreezingServiceUrl()));
        }
        if (tabs.size() == 0) {
            return;
        }
        initTab();
    }

    private View getQrCodeView(String title, String oldUrl) {
        String url = HttpsConstans.ROOT_URL + oldUrl;

        View view = View.inflate(mContext, R.layout.layout_qrcode_item, null);
        TextView tvTitle = view.findViewById(R.id.tv_qrcode_item_title);
        ImageView qrCode = view.findViewById(R.id.iv_qr_code);
        TextView tvUrl = view.findViewById(R.id.tv_qrcode_item_url);
        Button copyBtn = view.findViewById(R.id.btn_copy_url);
        tvTitle.setText(title + "二維碼");
        int width = ArmsUtils.getScreenWidth(mContext) / 3 * 2;
        qrCode.setImageBitmap(QRCodeUtil.createQRImage(url, width, width));
        tvUrl.setText(url);
        copyBtn.setOnClickListener(v -> {
            ClipboardManager cm = (ClipboardManager) getSystemService(Context.CLIPBOARD_SERVICE);
            ClipData label = ClipData.newPlainText("Label", url);
            cm.setPrimaryClip(label);
            ToastUtils.show(mContext, "已複製");
        });
        return view;
    }
}
