package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.Gravity;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.common.core.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.common.core.print.bean.OrderDetails;
import com.joe.print.R;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 測試頁打印
 */
public class PrintTest extends PrinterRoot {


    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        List<Bitmap> bitmaps = new ArrayList<>();
        bitmaps.add(getBitmap(mContext, deviceBean));
        bitmapMaps.put("", bitmaps);
        return bitmapMaps;
    }

    @Override
    public String[] getPrintDatas(Context mContext, PrinterDeviceBean deviceBean) {
        String stringBuilder = "<html><body>" +
                "<p>測試打印1<p/></br>" +
                "<p>測試打印2<p/></br>" +
                "<p>測試打印3<p/></br>" +
                "<p>測試打印4<p/></br>" +
                "<p>測試打印5<p/></br>" +
                "<row>" +
                " <column>This is an item with super long name</column>" +
                " <column offset=0.6>1</column>" +
                " <column offset=last>HKD 100</column>" +
                " </row>"+
                "</body></html>";
        String[] pritContent = new String[1];
        pritContent[0] = stringBuilder;
        return pritContent;
    }

    @Override
    public int getPrintCount(Context context) {
        return 1;
    }


    /**
     * 獲取測試打印bitmap
     *
     * @param context
     * @return
     */
    public Bitmap getTestPrintBitmap(Context context, PrinterDeviceBean deviceBean) {
        View view = LinearLayout.inflate(context, R.layout.print_test, null);
        TextView tvTime = view.findViewById(R.id.tv_test_print_now_time);
        tvTime.setText("時間：" + TimeUtils.getCurrentDate(TimeUtils.DEFAULT_DATE_FORMAT));
        return viewToZoomBitmap(context, view, deviceBean);
    }


    public Bitmap getBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);
        layout.addView(getTextView(mContext, "炒爐打印測試", Gravity.CENTER_HORIZONTAL, getDimensionPixelSize(mContext, R.dimen.dp_10)));
        layout.addView(getTextView(mContext, "時間：" + TimeUtils.getCurrentDate(TimeUtils.DEFAULT_DATE_FORMAT), Gravity.LEFT, getDimensionPixelSize(mContext, R.dimen.dp_8)));
        layout.addView(getTextLine(mContext, "項目"));

        List<OrderDetails.DataBean.PRODUCTNAMEBean> productnameBeans = new ArrayList<>();
        OrderDetails.DataBean.PRODUCTNAMEBean productnameBean = new OrderDetails.DataBean.PRODUCTNAMEBean();
        productnameBean.setPRODUCT_NAME("測試食品");
        productnameBean.setNum("1");
        productnameBean.setPRICE("10.0");

        List<OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX> childBeanXES = new ArrayList<>();
        OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX childBeanX = new OrderDetails.DataBean.PRODUCTNAMEBean.ChildBeanX();
        childBeanX.setPRODUCT_NAME("測試子食品");
        childBeanX.setNum("1");
        childBeanX.setPRICE("10.0");
        childBeanXES.add(childBeanX);
        productnameBean.setChild(childBeanXES);
        productnameBeans.add(productnameBean);

        layout.addView(getDiningFoodList(mContext, OrderDetail.productMameBeanToOrderDetail(0, productnameBeans), deviceBean, 0, true));
        layout.addView(getTextLine(mContext, "Powered by Gingersoft"));
//        layout.addView(getTextView(mContext, "(USB)", Gravity.CENTER_HORIZONTAL, getDimensionPixelSize(mContext, R.dimen.dp_8)));

        return viewToZoomBitmap(mContext, layout, deviceBean);
    }
}
