package com.joe.print.mvp.ui.adapter;

import androidx.annotation.Nullable;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.R;
import com.joe.print.mvp.model.bean.BillingBean;
import java.util.List;

/**
 * Created by Wyh on 2020/1/9.
 */
public class BillAdapter extends BaseQuickAdapter<BillingBean, BaseViewHolder> {

    public BillAdapter(@Nullable List<BillingBean> data) {
        super(R.layout.base_print_bill_adapter_item_bill, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, BillingBean item) {
        helper.setText(R.id.tv_bill_total_text, item.getOptionName());
        if (item.getTotalAmount() < 0) {
            helper.setText(R.id.tv_bill_total, "-$" + Math.abs(item.getTotalAmount()));
        } else if(item.getTotalAmount() > 0){
            helper.setText(R.id.tv_bill_total, "$" + item.getTotalAmount());
        }
    }
}
