package com.gingersoft.gsa.cloud.table.mvp.ui.widget;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.TableActivity;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.TableAdapter;
import com.gingersoft.gsa.cloud.common.ui.widget.dialog.BaseRetryDialog;
import com.jess.arms.utils.DeviceUtils;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.QMUIEmptyView;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-07-29
 * 修订历史：2020-07-29
 * 描述：
 */
public class SplitTableDialog extends BaseRetryDialog {

    private static final String TAG = "SplitTableDialog";
    private Context mContext;
    private SplitTableDialog mDialog;

    private int spanCount = 3;

    private int mRadius;
    private float mShadowAlpha = 0.25f;
    private int mShadowElevationDp = 14;
    private int mBagcolor;

    private int mainTableId;
    private List<TableBean.DataBean> mItems;
    private TableAdapter mAdapter;

    private QMUITopBar mTopBar;
    private QMUILinearLayout ll_container;

    private QMUIEmptyView mEmptyView;
    private ProgressBar progress;
    private RecyclerView recycler_table;
    private ImageView btn_close;

    public SplitTableDialog(@NonNull Context context) {
        super(context, R.style.MyDialogTheme2);
        mContext = context;
        mItems = new ArrayList<>();
        mRadius = QMUIDisplayHelper.dp2px(mContext, 8);
    }

    @Override
    public void show() {
        super.show();
    }

    public void addItem(TableBean.DataBean item) {
        mItems.add(item);
    }

    public void addItems(List<TableBean.DataBean> items) {
        if (mItems.size() > 0)
            mItems.clear();
        mItems.addAll(items);
    }

    public void clearItems(){
        if (mItems.size() > 0)
            mItems.clear();
        mAdapter.notifyDataSetChanged();
    }

    public void notifyDataSetChanged() {
        mEmptyView.hide();
        recycler_table.setVisibility(View.VISIBLE);
        mAdapter.notifyDataSetChanged();
    }

    public SplitTableDialog build() {
        if (mDialog != null) {
            return mDialog;
        }
        mDialog = new SplitTableDialog(mContext);
        View contentView = buildViews();
        int screenHeight = (int) (QMUIDisplayHelper.getScreenHeight(mContext) * 0.5);
        int screenWidth = (int) (QMUIDisplayHelper.getScreenWidth(mContext) * 0.8);
        mDialog.setContentView(contentView, new LinearLayout.LayoutParams(screenWidth, screenHeight));
        return mDialog;
    }

    private View buildViews() {
        View view = View.inflate(mContext, getContentViewLayoutId(), null);
        mTopBar = view.findViewById(R.id.topbar);
        recycler_table = view.findViewById(R.id.recycler_table);
        ll_container = view.findViewById(R.id.ll_container);
        mEmptyView = view.findViewById(R.id.emptyView);
        progress = view.findViewById(R.id.progress);
//            btn_close = view.findViewById(R.id.btn_close);
//            btn_close.setOnClickListener(new View.OnClickListener() {
//                @Override
//                public void onClick(View v) {
//                    closeDialog() ;
//                }
//            });
        ll_container.setRadiusAndShadow(mRadius, QMUIDisplayHelper.dp2px(mContext, mShadowElevationDp), mShadowAlpha);

        initTopbar();
        initTableRecycleView();
        return view;
    }

    private void initTopbar() {
        if (mBagcolor != 0) {
            mTopBar.setBackgroundColor(mBagcolor);
        } else {
            mTopBar.setBackgroundColor(ContextCompat.getColor(mContext, R.color.theme_color));
        }
        mTopBar.setTitle("分檯");
    }

    private void initTableRecycleView() {
        if (mAdapter == null) {
            mAdapter = new TableAdapter(mContext, mItems, DeviceUtils.getScreenHeight(mContext), TableActivity.FUNCTION_ALL_TABLE);
        }
        mAdapter.setOnItemClickListener(new TableAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(TableBean.DataBean datasBean, int position) {
                if (onClickListener != null) {
                    onClickListener.onItemClick(SplitTableDialog.this,datasBean, position);
                }
            }
        });
        recycler_table.setLayoutManager(createLayoutManager());
        recycler_table.setAdapter(mAdapter);
    }

    private RecyclerView.LayoutManager createLayoutManager() {
        return new GridLayoutManager(mContext, spanCount, LinearLayoutManager.VERTICAL, false) {
            @Override
            public RecyclerView.LayoutParams generateDefaultLayoutParams() {
                return new RecyclerView.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            }
        };
    }

    public void showEmptyView(boolean isSuccess, int size, Throwable t) {
        showEmptyView(isSuccess, size, t, mEmptyView, recycler_table);
    }

    public void setProgressVisibility(boolean show) {
        progress.setVisibility(show ? View.VISIBLE : View.INVISIBLE);
    }

    public int getMainTableId() {
        return mainTableId;
    }

    public void setMainTableId(int mainTableId) {
        this.mainTableId = mainTableId;
    }

    public void closeDialog() {
        mDialog.dismiss();
    }

    public void setTopBarBagcolor(int mBagcolor) {
        this.mBagcolor = mBagcolor;
    }

    protected int getContentViewLayoutId() {
        return R.layout.table_dialog_split;
    }

    private SplitTableDialog.OnClickListener onClickListener;

    public void setOnClickListener(SplitTableDialog.OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }

    public interface OnClickListener {

        void onItemClick(SplitTableDialog dialog, TableBean.DataBean item, int position);

    }
}
