package com.gingersoft.gsa.cloud.common.ui.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.common.R;
import com.gingersoft.gsa.cloud.common.R2;
import com.gingersoft.gsa.cloud.common.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.common.ui.utils.webviewUtils.WebImageListener;
import com.gingersoft.gsa.cloud.common.ui.utils.webviewUtils.WebViewUtils;
import com.gingersoft.gsa.cloud.common.ui.view.WebViewProgressBar;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.mvp.IView;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.DeviceUtils;
import com.jess.arms.utils.PermissionUtil;
import com.qmuiteam.qmui.alpha.QMUIAlphaImageButton;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.tbruyelle.rxpermissions2.RxPermissions;

import java.util.List;
import javax.inject.Inject;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import butterknife.BindView;
import butterknife.OnClick;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;

import static com.jess.arms.utils.Preconditions.checkNotNull;


public class WebActivity extends BaseActivity<BasePresenter> implements IView {

    @Inject
    RxErrorHandler mErrorHandler;

//    private CommonDialog msgDialog;

    //    @BindView(R.id.top_bar)
//    TitleBar mTopBar;
    @BindView(R2.id.topbar)
    QMUITopBar mTopBar;
    @BindView(R2.id.web_view)
    WebView mWebView;
    @BindView(R2.id.progress_bar)
    WebViewProgressBar mProgressBar;
    @BindView(R2.id.progress_bar1)
    ProgressBar mProgressBar1;
    @BindView(R2.id.tv_hint)
    TextView mTvHint;

    public static final String TYPE_KEY = "type_key";
    public static final String TITLE_KEY = "title_key";
    public static final String URL_KEY = "url_key";
    public static final String CONTENT_KEY = "content_key";

    public static final int URI = 100;
    public static final int CONTENT = 101;
    public static final int URI_CONTENT = 102;
    public static final int ADVERTISEMENT = 103;
    public static final int NEWSINFOCHILD = 104;
    public static final int TITLE_URI = 105;
    public static final int TITLE_CONTENT = 106;
    public static final int TITLE_URI_CONTENT = 107;


    public static final String RIGHT_IMG_TYPE = "right_img_type";
    public static final int RIGHT_TYPE_NULL = 0;
    public static final int RIGHT_TYPE_SHARE = 201;
    public static final int RIGHT_TYPE_REFRESH = 202;

    private boolean isContinue;
    private int mType;
    private String mUrl;
    private String mContent;
    private String mTitle;
//    private AdvertisementInfo adInfo;
//    private NewsInfoChild newsInfoChild;

    private boolean isReceivedTitle = true; //是否使用网页title
    private Intent intent;
    private int mRightType;//右边使用什么样的图片

    private boolean isNormalSizeToLargest;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
//        DaggerWebComponent //如找不到该类,请编译一下项目
//                .builder()
//                .appComponent(appComponent)
//                .webModule(new WebModule(this))
//                .build()
//                .inject(this);
    }

    @Override
    public int initView(Bundle savedInstanceState) {
        return R.layout.activity_web;
    }

    @Override
    public void initTopBar() {
        mTopBar.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color));
        mTopBar.addLeftBackImageButton().setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                killMyself();
            }
        });
        QMUIAlphaImageButton rightButton = mTopBar.addRightImageButton(R.drawable.icon_quick_action_share, R.id.topbar_right_change_button);
        rightButton.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {

            }
        });
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void initData(Bundle savedInstanceState) {

        intent = getIntent();
        isNormalSizeToLargest = intent.getBooleanExtra("isNormalSizeToLargest", false);

        initWebView();
        //初始化类型（带标题、不带标题、加载url、加载html、传递对象）
        initType();
        //加载webview
        initLoad();
    }

    @Override
    public void initIntent() {

    }

    @SuppressWarnings("deprecation")
    @SuppressLint("JavascriptInterface")
    private void initWebView() {
        //使用硬件加速
//        mWebView.setLayerType(View.LAYER_TYPE_SOFTWARE, null);

        WebImageListener listener = new WebImageListener(this);
        mWebView.addJavascriptInterface(listener, "listener");
        mWebView.addJavascriptInterface(this, "android");

        WebSettings settings = mWebView.getSettings();
        if (isNormalSizeToLargest) {
            settings.setTextSize(WebSettings.TextSize.LARGEST);
        }
        settings.setBlockNetworkImage(true);
        settings.setAppCacheEnabled(true);
        settings.setDomStorageEnabled(true);
        settings.setDatabaseEnabled(true);
        if (DeviceUtils.netIsConnected(this)) {
            settings.setCacheMode(WebSettings.LOAD_DEFAULT);
        } else {
            settings.setCacheMode(WebSettings.LOAD_CACHE_ONLY);
        }
        //防止https连接里面加载http图片
        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.LOLLIPOP) {
            settings.setMixedContentMode(WebSettings.LOAD_NORMAL);
        }
        settings.setBlockNetworkImage(false);
        settings.setJavaScriptEnabled(true);
        settings.setLoadWithOverviewMode(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        // 设置可以支持缩放
        settings.setSupportZoom(true);
        // 设置出现缩放工具
        settings.setBuiltInZoomControls(true);
        // 扩大比例的缩放
        settings.setUseWideViewPort(true);
        mWebView.setWebChromeClient(new MyWebChromeClient());
        mWebView.setWebViewClient(new MyWebViewClient());

        //可以设置是否允许通过file url加载的Javascript可以访问其他任何的源，也就是说，它包括其他的文件和http,https等其他的源
        settings.setAllowUniversalAccessFromFileURLs(true);
    }

    private class MyWebChromeClient extends WebChromeClient {

        @Override
        public void onProgressChanged(WebView view, int newProgress) {
            //loadingOperation(newProgress);
            if (newProgress == 100) {
                hideProgressWithAnim(mProgressBar1);
            } else {
                mProgressBar1.setVisibility(View.VISIBLE);
            }
            mProgressBar1.setProgress(newProgress);
        }

        @Override
        public void onReceivedTitle(WebView view, String title) {
            if (isReceivedTitle) {  //如果为true才从显示html标题
                if (title.startsWith("http://") || title.startsWith("https://")) {
                    mTopBar.setTitle("");
                } else {
                    mTitle = title;
                    mTopBar.setTitle(title);
                }
            }
        }
    }

    private class MyWebViewClient extends WebViewClient {

        @Override
        public void onPageFinished(WebView view, String url) {
            mRightType = intent.getIntExtra(RIGHT_IMG_TYPE, RIGHT_TYPE_NULL);
//            switch (mRightType) {
//                case RIGHT_TYPE_SHARE:
//                    mTopBar.setRightTwoIvVisibility(View.VISIBLE);
//                    mTopBar.setRightTwoImg(R.drawable.icon_share);
//                    break;
//                case RIGHT_TYPE_REFRESH:
//                    mTopBar.setRightTwoIvVisibility(View.VISIBLE);
//                    mTopBar.setRightTwoImg(R.drawable.ic_refresh);
//                    break;
//                default:
//                    mTopBar.setRightTwoIvVisibility(View.GONE);
//                    break;
//            }
            WebViewUtils.addImageClickListener(mWebView);
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (url == null) return false;
            try {
                if (url.startsWith("weixin://") //微信
                        || url.startsWith("alipays://") //支付宝
                        || url.startsWith("mailto://") //邮件
                ) {
                    Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                    startActivity(intent);
                    return true;
                }
                //判断用户单击的是那个超连接
                String tag = "tel";
                if (url.contains(tag)) {
                    PermissionUtil.callPhone(new PermissionUtil.RequestPermission() {
                        @SuppressLint("MissingPermission")
                        @Override
                        public void onRequestPermissionSuccess() {
                            String mobile = url.substring(url.lastIndexOf("/") + 1);
                            Intent mIntent = new Intent(Intent.ACTION_CALL);
                            Uri data = Uri.parse("tel:" + mobile);
                            mIntent.setData(data);
                            startActivity(mIntent);
                        }

                        @Override
                        public void onRequestPermissionFailure(List<String> permissions) {
                            showMessage(ArmsUtils.getString(WebActivity.this,R.string.authorize_call_phone));
                        }

                        @Override
                        public void onRequestPermissionFailureWithAskNeverAgain(List<String> permissions) {
//                            msgDialog = new CommonDialog(WebActivity.this, R.style.dialog_style, 0, 0, new View.OnClickListener() {
//                                @Override
//                                public void onClick(View v) {
//                                    switch (v.getId()) {
//                                        case R.id.txt_yes:
//                                            DeviceUtils.startSetting(WebActivity.this);
//                                            break;
//                                        case R.id.txt_no:
//                                            break;
//                                    }
//                                    msgDialog.dismiss();
//                                }
//                            });
//                            msgDialog.show();
//                            msgDialog.setTitle(ArmsUtils.getString(WebActivity.this, R.string.prompt));
//                            msgDialog.setContext(ArmsUtils.getString(WebActivity.this, R.string.authorize_call_phone));
                        }
                    }, new RxPermissions(WebActivity.this), mErrorHandler);
                    return true;
                }
            } catch (Exception e) {
                e.printStackTrace();
                return true;
            }
            view.loadUrl(url);
            return true;
        }

        // 错误页面的逻辑处理
        @SuppressWarnings("deprecation")
        @Override
        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            //errorOperation();
            mWebView.setVisibility(View.INVISIBLE);
            mTvHint.setVisibility(View.VISIBLE);
        }

    }

    private void initType() {
        mType = intent.getIntExtra(TYPE_KEY, 0);
        if (mType == URI || mType == CONTENT || mType == URI_CONTENT) {
            setReceivedTitleStatus(null);
        } else if (mType == TITLE_URI || mType == TITLE_CONTENT || mType == TITLE_URI_CONTENT) {
            mTitle = intent.getStringExtra(TITLE_KEY);
            setReceivedTitleStatus(mTitle);
        }
//        else if (mType == ADVERTISEMENT) {
//            adInfo = (AdvertisementInfo) intent.getSerializableExtra("AdvertisementInfo");
//            setReceivedTitleStatus(adInfo.getAdTitle());
//        } else if (mType == NEWSINFOCHILD) {
//            newsInfoChild = (NewsInfoChild) intent.getSerializableExtra("NewsInfoChild");
//            setReceivedTitleStatus(newsInfoChild.getAdTitle());
//        }
        else {
            setReceivedTitleStatus(null);
        }
    }

    private void initLoad() {
        switch (mType) {
            case URI:
                mUrl = intent.getStringExtra(URL_KEY);

                if (!TextUtils.isEmpty(mUrl) && !mUrl.toLowerCase().equals("null")) {
                    mWebView.loadUrl(mUrl);
                }
                break;
            case CONTENT:
                mContent = intent.getStringExtra(CONTENT_KEY);

                if (!TextUtils.isEmpty(mContent) && !mContent.toLowerCase().equals("null")) {
                    mWebView.loadDataWithBaseURL(null, mContent, "text/html", "utf-8", null);
                }
                break;
            case URI_CONTENT:
                mUrl = intent.getStringExtra(URL_KEY);
                mContent = intent.getStringExtra(CONTENT_KEY);

                if (!TextUtils.isEmpty(mUrl) && !mUrl.toLowerCase().equals("null")) {
                    mWebView.loadUrl(mUrl);
                } else if (!TextUtils.isEmpty(mContent) && !mContent.toLowerCase().equals("null")) {
                    mWebView.loadDataWithBaseURL(null, mContent, "text/html", "utf-8", null);
                }
                break;
            case TITLE_URI:
                mUrl = intent.getStringExtra(URL_KEY);
                mTitle = intent.getStringExtra(TITLE_KEY);

                mTopBar.setTitle(mTitle);
                if (!TextUtils.isEmpty(mUrl)) {
                    mWebView.loadUrl(mUrl);
                }

                break;
            case TITLE_CONTENT:
                mTitle = intent.getStringExtra(TITLE_KEY);
                mContent = intent.getStringExtra(CONTENT_KEY);

                mTopBar.setTitle(mTitle);
                if (!TextUtils.isEmpty(mContent) && !mContent.toLowerCase().equals("null")) {
                    mWebView.loadDataWithBaseURL(null, mContent, "text/html", "utf-8", null);
                }
                break;
            case TITLE_URI_CONTENT:
                mTitle = intent.getStringExtra(TITLE_KEY);
                mUrl = intent.getStringExtra(URL_KEY);
                mContent = intent.getStringExtra(CONTENT_KEY);

                mTopBar.setTitle(mTitle);
                if (!TextUtils.isEmpty(mUrl) && !mUrl.toLowerCase().equals("null")) {
                    mWebView.loadUrl(mUrl);
                } else if (!TextUtils.isEmpty(mContent) && !mContent.toLowerCase().equals("null")) {
                    mWebView.loadDataWithBaseURL(null, mContent, "text/html", "utf-8", null);
                }
                break;
//            case ADVERTISEMENT:
//                if (adInfo != null) {
//                    mTitle = adInfo.getAdTitle();
//                    mTopBar.setTitle(mTitle);
////                    if (adInfo.getAdType().equals("0")) {
////                        mWebView.loadDataWithBaseURL(null, adInfo.getAdDesc(), "text/html", "utf-8", null);
////                    } else if (adInfo.getAdType().equals("1")) {
//                    String url = (SApplication.adServerAddress() + adURL + adInfo.getId()).replace("member-web/", "");
//                    mWebView.loadUrl(url);
////                    } else {
////                        mWebView.loadDataWithBaseURL(null,adInfo.getAdUrl(), "text/html", "utf-8", null);
////                    }
//                }
//                break;
//            case NEWSINFOCHILD:
//                if (newsInfoChild != null) {
//                    mTitle = newsInfoChild.getAdTitle();
//                    mTopBar.setCenterText(mTitle);
//                    String url = (SApplication.adServerAddress() + adURL + newsInfoChild.getId()).replace("member-web/", "");
//                    mWebView.loadUrl(url);
//                }
//                break;
            case 0:
                break;
        }
    }


    /**
     * 是否使用其他頁面传递过来的标题
     *
     * @param title
     */
    private void setReceivedTitleStatus(String title) {
        if (!TextUtils.isEmpty(title)) {
            isReceivedTitle = false;
        } else {
            isReceivedTitle = true;
        }
    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
//        ArmsUtils.snackbarText(message);
        ToastUtils.show(mContext, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
//        getMenuInflater().inflate(R.Menu.menu_mTopBar_web_activity, Menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();
//        if (id == android.R.id.home) {
//            finish();
//        } else if (id == R.id.action_share) {
//            DiycodeUtils.shareText(this, mWebView.getTitle(), mWebView.getUrl());
//        } else if (id == R.id.action_refresh) {
//            mWebView.reload();
//        } else if (id == R.id.action_open_browser) {
//            DiycodeUtils.openBrowser(this, mUrl);
//        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onBackPressed() {
        if (mWebView.canGoBack()) {
            mWebView.goBack();
        } else {
            super.onBackPressed();
        }
    }

    @Override
    protected void onDestroy() {
        clearWebViewResource();
        super.onDestroy();
    }

    private void clearWebViewResource() {
        if (mWebView != null) {
            mWebView.removeAllViews();
            // in android 5.1(sdk:21) we should invoke this to avoid memory leak
            // see (https://coolpers.github.io/webview/memory/leak/2015/07/16/android-5.1-webview-memory-leak.html)
            ((ViewGroup) mWebView.getParent()).removeView(mWebView);
            mWebView.setTag(null);
            mWebView.clearHistory();
            mWebView.destroy();
            mWebView = null;
        }
    }

    @OnClick(R2.id.tv_hint)
    void clickHint() {
        mTvHint.setVisibility(View.INVISIBLE);
        mWebView.setVisibility(View.VISIBLE);
        mWebView.reload();
    }

    private void loadingOperation(int newProgress) {
        // 如果没有网络直接跳出方法
//        if (!NetWorkUtils.isAvailableByPing()) {
        if (!DeviceUtils.netIsConnected(this)) {
            return;
        }
        // 如果进度条隐藏则让它显示
        if (View.INVISIBLE == mProgressBar.getVisibility()) {
            mProgressBar.setVisibility(View.VISIBLE);
        }
        // 大于80的进度的时候，放慢速度加载，否则交给自己加载
        if (newProgress >= 80) {
            // 拦截webView自己的处理方式
            if (isContinue) {
                return;
            }
            mProgressBar.setCurProgress(100, 3000, () -> {
                finishOperation(true);
                isContinue = false;
            });
            isContinue = true;
        } else {
            mProgressBar.setNormalProgress(newProgress);
        }
    }

    private void errorOperation() {
        // 隐藏webview
        mWebView.setVisibility(View.INVISIBLE);
        if (View.INVISIBLE == mProgressBar.getVisibility()) {
            mProgressBar.setVisibility(View.VISIBLE);
        }
        //3.5s 加载 0->80 进度的加载 为了实现，特意调节长了事件
        mProgressBar.setCurProgress(80, 3500, () -> {
            //3.5s 加载 80->100 进度的加载
            mProgressBar.setCurProgress(100, 3500, () -> finishOperation(false));
        });
    }

    private void finishOperation(boolean flag) {
        // 最后加载设置100进度
        mProgressBar.setNormalProgress(100);
        // 显示网络异常布局
        mTvHint.setVisibility(flag ? View.INVISIBLE : View.VISIBLE);
        hideProgressWithAnim(mProgressBar);
    }

    private void hideProgressWithAnim(final View progressBar) {
        AnimationSet animation = new AnimationSet(this, null);
        AlphaAnimation alpha = new AlphaAnimation(1.0f, 0.0f);
        alpha.setDuration(1000);
        animation.addAnimation(alpha);
        animation.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                progressBar.setVisibility(View.INVISIBLE);
            }

            @Override
            public void onAnimationRepeat(Animation animation) {
            }
        });
        progressBar.startAnimation(animation);
    }

    @JavascriptInterface
    public void adResults(String title, String content) {
//        OnekeyShare.showWebShare(this, title, content);
    }

//    /**
//     * @param type    1 （餐牌模式）餐厅详情 2品牌介绍3餐厅外卖
//     * @param jsonStr 入参json字符串
//     */
//    @JavascriptInterface
//    public void startFunction(int type, String jsonStr) {
//
//        boolean flatbedloginStatus = (int) SPUtils.get(this, SPConstant.FLATBED_LOGIN_STATUS, -1) != -1 ? true : false;
//        if (flatbedloginStatus)
//            return;
//
//        if (TextUtils.isEmpty(jsonStr) || jsonStr.equals("null")) {
//            showMessage("沒有傳入相關參數");
//            return;
//        }
//        try {
//            JSONObject jsonObj = new JSONObject(jsonStr);
//            if (type == 1 || type == 3) {
//                String restaurantId = jsonObj.optString("restaurantId");
//                if (!TextUtils.isEmpty(restaurantId) || !restaurantId.equals("null")) {
//                    Intent intent = new Intent(this, RestaurantActivity.class);
//                    intent.putExtra("id", restaurantId);
//                    if (type == 1) {
//                        intent.putExtra("menuType", DefaultConfig.MENU_TYPE_DETAILS);
//                    } else {
//                        intent.putExtra("menuType", DefaultConfig.MENU_TYPE_TAKEAWAY);
//                    }
//                    startActivity(intent);
//                }
//            } else if (type == 2) {
//                String brandId = jsonObj.optString("brandId");
//                if (!TextUtils.isEmpty(brandId) || !brandId.equals("null")) {
//                    Intent intent = new Intent(this, JoinMemberCardActivity.class);
//                    intent.putExtra(DefaultConfig.BRAND_ID, Integer.valueOf(brandId));
//                    startActivity(intent);
//                }
//            }
//        } catch (JSONException e) {
//            e.printStackTrace();
//        }
//    }

    public static void startWebActivityForResult_url(Activity context, String url, int rightType, int reslutCode) {
        Intent intent = new Intent(context, WebActivity.class);
        intent.putExtra(TYPE_KEY, URI);
        intent.putExtra(URL_KEY, url);
        intent.putExtra(RIGHT_IMG_TYPE, rightType);
        context.startActivityForResult(intent, reslutCode);
    }

    public static void startWebActivity_url(Context context, String url, int rightType) {
        Intent intent = new Intent(context, WebActivity.class);
        intent.putExtra(TYPE_KEY, URI);
        intent.putExtra(URL_KEY, url);
        intent.putExtra(RIGHT_IMG_TYPE, rightType);
        context.startActivity(intent);
    }

    public static void startWebActivity_content(Context context, String content, int rightType) {
        Intent intent = new Intent(context, WebActivity.class);
        intent.putExtra(TYPE_KEY, CONTENT);
        intent.putExtra(CONTENT_KEY, content);
        intent.putExtra(RIGHT_IMG_TYPE, rightType);
        context.startActivity(intent);
    }

    public static void startWebActivity_uri_content(Context context, String url, String content, int rightType) {
        Intent intent = new Intent(context, WebActivity.class);
        intent.putExtra(TYPE_KEY, URI_CONTENT);
        intent.putExtra(URL_KEY, url);
        intent.putExtra(CONTENT_KEY, content);
        intent.putExtra(RIGHT_IMG_TYPE, rightType);
        context.startActivity(intent);
    }

    public static void startWebActivity_title_url(Context context, String title, String url, int rightType) {
        Intent intent = new Intent(context, WebActivity.class);
        intent.putExtra(TYPE_KEY, TITLE_URI);
        intent.putExtra(TITLE_KEY, title);
        intent.putExtra(URL_KEY, url);
        intent.putExtra(RIGHT_IMG_TYPE, rightType);
        context.startActivity(intent);
    }

    public static void startWebActivity_title_content(Context context, String title, String content, int rightType, boolean isNormalSizeToLargest) {
        Intent intent = new Intent(context, WebActivity.class);
        intent.putExtra(TYPE_KEY, TITLE_CONTENT);
        intent.putExtra(TITLE_KEY, title);
        intent.putExtra(CONTENT_KEY, content);
        intent.putExtra(RIGHT_IMG_TYPE, rightType);
        intent.putExtra("isNormalSizeToLargest", isNormalSizeToLargest);
        context.startActivity(intent);
    }

    public static void startWebActivity_title_url_content(Context context, String title, String url, String content, int rightType) {
        Intent intent = new Intent(context, WebActivity.class);
        intent.putExtra(TYPE_KEY, TITLE_URI_CONTENT);
        intent.putExtra(TITLE_KEY, title);
        intent.putExtra(URL_KEY, url);
        intent.putExtra(CONTENT_KEY, content);
        intent.putExtra(RIGHT_IMG_TYPE, rightType);
        context.startActivity(intent);
    }

//    public static void startWebActivity_Advertisement(Context context, AdvertisementInfo info, int rightType) {
//        Intent intent = new Intent(context, WebActivity.class);
//        intent.putExtra(TYPE_KEY, ADVERTISEMENT);
//        intent.putExtra(RIGHT_IMG_TYPE, rightType);
//        intent.putExtra("AdvertisementInfo", info);
//        context.startActivity(intent);
//    }
//
//    public static void startWebActivity_NewsInfoChild(Context context, NewsInfoChild newsInfoChild, int rightType) {
//        Intent intent = new Intent(context, WebActivity.class);
//        intent.putExtra(TYPE_KEY, NEWSINFOCHILD);
//        intent.putExtra(RIGHT_IMG_TYPE, rightType);
//        intent.putExtra("NewsInfoChild", newsInfoChild);
//        context.startActivity(intent);
//    }

}
