package com.gingersoft.gsa.cloud.common.ui.adapter.multi;

import android.content.Context;
import android.view.View;
import android.widget.CheckBox;

import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.R;
import com.gingersoft.gsa.cloud.common.ui.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.common.ui.recylcler.decorator.DividerItemDecoration;

import org.jetbrains.annotations.NotNull;

import static com.gingersoft.gsa.cloud.common.ui.recylcler.decorator.DividerItemDecoration.VERTICAL_LIST;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/29
 * Time: 15:58
 * Use:
 */
public class RadioProvider extends MyBaseItemProvider {

    private Context context;

    public RadioProvider(Context context) {
        this.context = context;
    }

    @Override
    public int getItemViewType() {
        return InfoMultiBean.ITEM_TYPE_SHOW_LIST;
    }

    @Override
    public int getLayoutId() {
        return R.layout.multi_radio;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, InfoMultiBean infoMultiBean) {
        super.convert(baseViewHolder, infoMultiBean);
        baseViewHolder.setText(R.id.rb_multi, infoMultiBean.getShowValue());
        if (infoMultiBean.getInfoMultiBeans() != null) {
            RecyclerView rv = baseViewHolder.getView(R.id.rv_radio_multi);
            CheckBox checkBox = baseViewHolder.getView(R.id.rb_multi);

            rv.setVisibility(checkBox.isChecked() ? View.VISIBLE : View.GONE);
            rv.addItemDecoration(new DividerItemDecoration(context, VERTICAL_LIST));

            InfoMultiAdapter infoMultiAdapter = new InfoMultiAdapter(context, infoMultiBean.getInfoMultiBeans());
            rv.setAdapter(infoMultiAdapter);

            checkBox.setOnCheckedChangeListener((buttonView, isChecked) -> {
                rv.setVisibility(isChecked ? View.VISIBLE : View.GONE);
            });
        }
    }
}
