package com.gingersoft.gsa.cloud.common.ui.bean.view;

import com.qmuiteam.qmui.widget.section.QMUISection.Model;

import java.util.Objects;

/**
 * 文字加圖片
 */
public class SectionNormalItem implements Model<SectionNormalItem> {
    private int image;
    private String text;

    public SectionNormalItem(int image, String text) {
        this.image = image;
        this.text = text;
    }

    public String getText() {
        return text;
    }

    public int getImage() {
        return image;
    }

    @Override
    public SectionNormalItem cloneForDiff() {
        return new SectionNormalItem(getImage(), getText());
    }

    @Override
    public boolean isSameItem(SectionNormalItem other) {
        return Objects.equals(text, other.text);
    }

    @Override
    public boolean isSameContent(SectionNormalItem other) {
        return true;
    }
}
