package com.gingersoft.gsa.delivery_pick_mode.data.network

import com.gingersoft.gsa.cloud.common.config.globalconfig.applyOptions.intercept.HeadersInterceptor
import com.gingersoft.gsa.cloud.common.constans.HttpsConstans
import com.gingersoft.gsa.cloud.common.constans.HttpsConstans.ROOT_SERVER
import com.gingersoft.gsa.cloud.common.constans.HttpsConstans.URK_RICEPON_GSA
import com.jess.arms.http.log.RequestInterceptor
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.converter.scalars.ScalarsConverterFactory
import java.util.concurrent.TimeUnit

object ServiceCreator {

    private val httpClient = OkHttpClient.Builder()
            .connectTimeout(30, TimeUnit.SECONDS)
            .callTimeout(30, TimeUnit.SECONDS)
            .readTimeout(30, TimeUnit.SECONDS)
            .writeTimeout(30, TimeUnit.SECONDS)
            .addInterceptor(RequestInterceptor())
            .addInterceptor(HeadersInterceptor())

    private lateinit var builder: Retrofit.Builder
    private lateinit var builder2: Retrofit.Builder
    private lateinit var builder3: Retrofit.Builder
    private lateinit var builder4: Retrofit.Builder
    private lateinit var builder5: Retrofit.Builder
    private lateinit var builderSystem: Retrofit.Builder
    private lateinit var builderActivities: Retrofit.Builder
    private lateinit var builderGSA: Retrofit.Builder
    private lateinit var builderRootGSA: Retrofit.Builder

    init {
        init()
    }

    fun init() {
        builder = Retrofit.Builder()
                .baseUrl(HttpsConstans.ricepon_wechat)
                .client(httpClient.build())

                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
        builder2 = Retrofit.Builder()
                .baseUrl(HttpsConstans.member_web)
                .client(httpClient.build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
        builder3 = Retrofit.Builder()
                .baseUrl(HttpsConstans.member_web_ricepon_gsa)
                .client(httpClient.build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
        builder4 = Retrofit.Builder()
                .baseUrl(HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL)
                .client(httpClient.build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
        builder5 = Retrofit.Builder()
                .baseUrl(HttpsConstans.ricepon_order)
                .client(httpClient.build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
        builderSystem = Retrofit.Builder()
                .baseUrl(HttpsConstans.SYSTEM_URL)
                .client(httpClient.build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
        builderActivities = Retrofit.Builder()
                .baseUrl(HttpsConstans.ricepon_activities)
                .client(httpClient.build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
        builderGSA = Retrofit.Builder().baseUrl(ROOT_SERVER + URK_RICEPON_GSA)
                .client(httpClient.build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
        builderRootGSA = Retrofit.Builder().baseUrl(HttpsConstans.ricepon_gsa)
                .client(httpClient.build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
    }

    fun <T> create(serviceClass: Class<T>): T = builder.build().create(serviceClass)

    fun <T> create2(serviceClass: Class<T>): T = builder2.build().create(serviceClass)

    fun <T> create3(serviceClass: Class<T>): T = builder3.build().create(serviceClass)

    fun <T> create4(serviceClass: Class<T>): T = builder4.build().create(serviceClass)

    fun <T> create5(serviceClass: Class<T>): T = builder5.build().create(serviceClass)

    fun <T> createSystem(serviceClass: Class<T>): T = builderSystem.build().create(serviceClass)

    fun <T> createActivities(service: Class<T>): T = builderActivities.build().create(service)

    fun <T> createGSA(service: Class<T>): T = builderGSA.build().create(service)

    fun <T> createRootGSA(service: Class<T>): T = builderRootGSA.build().create(service)

}