package com.gingersoft.supply_chain.mvp.bean;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/19
 * Time: 18:01
 * Use: 供應商信息
 */
@Data
public class SupplierInfoBean implements Serializable {
    private static final long serialVersionUID = 9167054021101810555L;

    private int id;
    private String supplierNo;
    private String contactInformation;
    private String supplierName;
    private String address;
    private String remarks;
    private String contacts;
    private String createDate;
    private int restaurantId;
    private int brandId;
    private int uid;
    private int countryId;
    private long createTime;
    private long updateTime;
    private int deletes;


    private List<SupplierContacts> supplierContacts;

    public SupplierInfoBean(String supplierName, String address, String contactInformation, String contacts, String createDate) {
        this.contactInformation = contactInformation;
        this.supplierName = supplierName;
        this.address = address;
        this.contacts = contacts;
        this.createDate = createDate;
    }

    public SupplierInfoBean() {
    }

    @Data
    public static class SupplierContacts implements Serializable {
        private static final long serialVersionUID = -4586838211196656718L;
        private String configText;
        /**
         * 聯繫方式
         * 1、郵箱
         * 2、座機
         * 3、Whatsapp
         * 4、wehat
         * 5、line
         * 6、Kakao
         * 7、Talk
         * 8、SMS
         * 9、efax
         */
        private int type;
        public final static int Email = 1;
        public final static int Landline = 2;
        public final static int Whatsapp = 3;
        public final static int WeChat = 4;
        public final static int Line = 5;
        public final static int Kakao = 6;
        public final static int Talk = 7;
        public final static int SMS = 8;
        public final static int Efax = 9;

        public SupplierContacts(String configText, int type) {
            this.configText = configText;
            this.type = type;
        }
    }
}
