package com.gingersoft.gsa.cloud.main.mvp.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;

import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DaySalesReportBean;
import com.gingersoft.gsa.cloud.ui.widget.BaseReloadView;

public class BillingAnalysisReportView extends BaseReloadView {

    private boolean isPrint = false;

    private TextView tvBillNum;
    private TextView tvBillAverage;
    private TextView tvPeople;
    private TextView tvPeopleAvgPrice;

    private DaySalesReportBean.DataBean dataBean;

    public BillingAnalysisReportView(@NonNull Context context) {
        this(context, null);
    }

    public BillingAnalysisReportView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public BillingAnalysisReportView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public BillingAnalysisReportView setPrint(boolean print) {
        isPrint = print;
        return this;
    }

    public BillingAnalysisReportView setDataBean(DaySalesReportBean.DataBean dataBean) {
        this.dataBean = dataBean;
        return this;
    }

    @Override
    public boolean getDataIsNull() {
        return !isPrint && dataBean == null;
    }

    @Override
    public ViewGroup getChildView() {
        View view = View.inflate(getContext(), R.layout.layout_report_billing_analysis, null);
        TextView tvTitle = view.findViewById(R.id.tv_bill_analysis_title);
        tvBillNum = view.findViewById(R.id.tv_report_bill_number);
        tvBillAverage = view.findViewById(R.id.tv_report_bill_average_price);
        tvPeople = view.findViewById(R.id.tv_report_people_number);
        tvPeopleAvgPrice = view.findViewById(R.id.tv_report_people_average_price);

        View horizontalLine = view.findViewById(R.id.horizontal_dividing_line);
        View verticalLine = view.findViewById(R.id.vertical_dividing_line);
        if (isPrint) {
            tvTitle.setTextSize(30);

            ((TextView) view.findViewById(R.id.tv_bill_number_text)).setTextSize(26);
            ((TextView) view.findViewById(R.id.tv_people_text)).setTextSize(26);

            tvBillNum.setTextSize(28);
            tvBillAverage.setTextSize(20);

            tvPeople.setTextSize(28);
            tvPeopleAvgPrice.setTextSize(20);

            horizontalLine.setBackgroundColor(ContextCompat.getColor(getContext(), R.color.black));
            verticalLine.setBackgroundColor(ContextCompat.getColor(getContext(), R.color.black));
        }
        refreshData();
        return view.findViewById(R.id.layout_business_info);
    }



    @Override
    public void refreshData() {
        if (dataBean != null) {
            tvBillNum.setText(dataBean.getBillNum() + "");
            tvBillAverage.setText("單均價：$" + MoneyUtil.divide(dataBean.getFoodAmount(), dataBean.getBillNum()));
            tvPeople.setText(dataBean.getBillPerson() + "");
            tvPeopleAvgPrice.setText("人均價：$" + MoneyUtil.divide(dataBean.getFoodAmount(), dataBean.getBillPerson()));
        }
    }
    public void setData(DaySalesReportBean.DataBean dataBean) {
        this.dataBean = dataBean;
        notifyData();
    }
}

