package com.gingersoft.supply_chain.mvp.ui.adapter.dishes;

import android.content.Context;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.CollectionUtils;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.DeputyUnitBean;
import com.gingersoft.supply_chain.mvp.bean.DishDetailBean;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author zjs.
 * 菜品食材綁定列表
 */
public class DishDetailAdapter extends BaseQuickAdapter<DishDetailBean, BaseViewHolder> {

    public DishDetailAdapter(Context context, List<DishDetailBean> foods) {
        super(R.layout.item_dishes_foods,foods);
        addChildClickViewIds(R.id.tv_dishes_unit,R.id.tv_dishes_del);
    }


    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, DishDetailBean item) {
        viewHolder.setText(R.id.tv_dishes_name, item.getFoodName());//食材名字
        viewHolder.setText(R.id.tv_dishes_unit, item.getBasicUnitName());//配置的單位
        if (item.isShow()) {
//            viewHolder.itemView.setVisibility(View.VISIBLE);
//            viewHolder.setTextColor(R.id.tv_dishes_name, ArmsUtils.getColor(context, R.color.color_18));
        } else {
//            viewHolder.itemView.setVisibility(View.GONE);
//            viewHolder.setTextColor(R.id.tv_dishes_name, ArmsUtils.getColor(context, R.color.switcher_off_color));
        }

//        viewHolder.setText(R.id.tv_dishes_unit, item.getUnitName());
        List<DeputyUnitBean> deputyUnitBeans= item.getFoodUnits();//副單位
        if (CollectionUtils.isNullOrEmpty(deputyUnitBeans)) {
//            addChildClickViewIds(R.id.tv_dishes_unit); consumeQuantity
        }
        viewHolder.setText(R.id.tv_dishes_count, String.valueOf(item.getConsumeQuantity()));//消耗數量
    }

}
