package com.gingersoft.supply_chain.mvp.ui.adapter.dishes;

import android.graphics.Typeface;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.core.view.ViewCompat;

import com.chad.library.adapter.base.entity.node.BaseNode;
import com.chad.library.adapter.base.provider.BaseNodeProvider;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.CollectionUtils;
import com.gingersoft.gsa.cloud.common.utils.log.LogUtil;
import com.gingersoft.supply_chain.R;

import org.jetbrains.annotations.NotNull;

import java.util.List;

public class DishesGroupProvider extends BaseNodeProvider {
    @Override
    public int getItemViewType() {
        return DishesTreeAdapter.DISHESGROUP;
    }

    @Override
    public int getLayoutId() {
        return R.layout.item_dish_group;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, BaseNode baseNode) {
        DishesGroupNode entity = (DishesGroupNode) baseNode;
        baseViewHolder.setText(R.id.tv_dishes_group_title, entity.getFoodName());
        if (entity.isExpanded()) {
            baseViewHolder.setImageResource(R.id.iv_dishes_group_icon, R.drawable.ic_dishes_up);
        } else {
            baseViewHolder.setImageResource(R.id.iv_dishes_group_icon, R.drawable.ic_dishes_down);
        }
        setArrowSpin(baseViewHolder, baseNode, false);

    }


    @Override
    public void convert(@NotNull BaseViewHolder helper, @NotNull BaseNode data, @NotNull List<?> payloads) {
        for (Object payload : payloads) {
            if (payload instanceof Integer && (int) payload == DishesTreeAdapter.EXPAND_COLLAPSE_PAYLOAD) {
                // 增量刷新，使用动画变化箭头
                setArrowSpin(helper, data, true);
            }
        }
    }

    private void setArrowSpin(BaseViewHolder helper, BaseNode data, boolean isAnimate) {
        DishesGroupNode entity = (DishesGroupNode) data;

        ImageView imageView = helper.getView(R.id.iv_dishes_group_icon);
        TextView title = helper.getView(R.id.tv_dishes_group_title);
        List<DishNode> child= entity.getDishNodes();
        if (CollectionUtils.isNotNullOrEmpty(child)) {
            imageView.setVisibility(View.VISIBLE);
            if (entity.isExpanded()) {
                title.setTypeface(Typeface.SANS_SERIF, Typeface.BOLD);
                if (isAnimate) {
                    ViewCompat.animate(imageView).setDuration(200)
                            .setInterpolator(new DecelerateInterpolator())
                            .rotation(180f)
                            .start();
                } else {
                    imageView.setRotation(180f);
                }
            } else {
                title.setTypeface(Typeface.SANS_SERIF, Typeface.NORMAL);
                if (isAnimate) {
                    ViewCompat.animate(imageView).setDuration(200)
                            .setInterpolator(new DecelerateInterpolator())
                            .rotation(0f)
                            .start();
                } else {
                    imageView.setRotation(0f);
                }
            }
        }else {
            imageView.setVisibility(View.INVISIBLE);
        }

    }

    @Override
    public void onClick(@NotNull BaseViewHolder helper, @NotNull View view, BaseNode data, int position) {
        // 这里使用payload进行增量刷新（避免整个item刷新导致的闪烁，不自然）

        DishesGroupNode groupNode= (DishesGroupNode)data;
        List<DishNode> dishNodes= groupNode.getDishNodes();
        LogUtil.e("zjs","父菜单点击 onClick position ="+position+" getFoodName"+groupNode.getFoodName()+" groupNode="+groupNode.isExpanded());
        if (CollectionUtils.isNotNullOrEmpty(dishNodes)) {
            if (groupNode.getPos()==0) {
                groupNode.setPos(1);
                DishNode dishNode = dishNodes.get(0);
                dishNode.setSelect(true);
                if (defaultClick != null) {
                    defaultClick.onChildClick(dishNode);
                }
            }

        }
        if (groupNode.isExpanded()) {
            getAdapter().expandOrCollapse(position, true, true, DishesTreeAdapter.EXPAND_COLLAPSE_PAYLOAD);
        }else {
            getAdapter().expandAndCollapseOther(position,true);
        }

    }

    private defaultClick defaultClick;

    public void setDefaultClick(DishesGroupProvider.defaultClick defaultClick) {
        this.defaultClick = defaultClick;
    }

    public interface defaultClick {
        void onChildClick(DishNode dishNode);
    }
}
