package com.gingersoft.gsa.cloud.pay.device.pos.yedpay.lifecycle.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.order.R;
import com.gingersoft.gsa.cloud.pay.PayStep;
import com.gingersoft.gsa.cloud.pay.RequestParms;
import com.gingersoft.gsa.cloud.pay.device.pos.base.lifecycle.fragment.PosMatterFragment;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.constant.YedpayConstant;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.lifecycle.di.component.DaggerYedpayMatterComponent;
import com.jess.arms.di.component.AppComponent;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.lifecycle.contract.YedpayMatterContract;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.lifecycle.presenter.YedpayMatterPresenter;
import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 05/10/2021 10:50
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class YedpayMatterFragment extends PosMatterFragment<YedpayMatterPresenter> implements YedpayMatterContract.View {

    public static YedpayMatterFragment newInstance(RequestParms requestParms) {
        Bundle bundle = new Bundle();
        YedpayMatterFragment fragment = new YedpayMatterFragment();
        bundle.putParcelable("requestParms", requestParms);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerYedpayMatterComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        super.initData(savedInstanceState);
    }

    @Override
    protected void retrievalStatus() {
        mPresenter.executeRetrieval(requestParms);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        LoganManager.w_code(TAG, "onActivityResult->" + "resultCode=" + resultCode + "  requestCode=" + requestCode);
        if (resultCode == android.app.Activity.RESULT_OK) {
            switch (requestCode) {
                case YedpayConstant.CallRequestCode.RETRIEVAL_REQUEST_CODE: {
                    if (intent.getExtras() != null) {
                        String status = (String) intent.getExtras().get("status");
                        String transaction_id = (String) intent.getExtras().get("transaction_id");
                        LoganManager.w_code(TAG, "onActivityResult-》" + "status=" + status + "  transaction_id=" + transaction_id);
                        mPresenter.findSaleStatus(transaction_id, requestParms.getOrderId(), requestParms.getPayType(), requestParms.getResturantId(), requestParms.getTxnId());
                    }
                    break;
                }
                default:
                    break;
            }
        }
    }

    @Override
    public void setPosMatterStep(boolean success, String name) {
        super.setMatterStatus(success,name);
    }

    @Override
    public void startActivityForResult2(Intent intent, int requestCode) {
        startActivityForResult(intent, requestCode);
    }
}
