package com.gingersoft.gsa.cloud.pay.widget;

import android.app.Dialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.order.R;
import com.gingersoft.gsa.cloud.pay.view.customstatus.CustomStatusView;
import com.jess.arms.utils.ArmsUtils;


public class StatusLoadingDialog {

    private Context mContext;
    private Dialog dialog;

    private LinearLayout ll_container;
    private CustomStatusView as_status;
    private TextView tv_status;

    private long mCancelDelayMillis = 1500;
    private String mLoadingText = "支付中...";

    public StatusLoadingDialog(Context context, String loadingText) {
        this.mContext = context;
        this.mLoadingText = loadingText;

        initView();
    }

    public StatusLoadingDialog(Context context, String loadingText, long cancelDelayMillis) {
        this.mContext = context;
        this.mCancelDelayMillis = cancelDelayMillis;
        this.mLoadingText = loadingText;

        initView();
    }

    private void initView() {
        View view = LayoutInflater.from(mContext).inflate(R.layout.dialog_command_loading, null);

        ll_container = view.findViewById(R.id.ll_container);
        as_status = view.findViewById(R.id.as_status);
        tv_status = view.findViewById(R.id.tv_status);
        // 定义Dialog布局和参数
        dialog = new Dialog(mContext, R.style.ui_loading_dialog);
        dialog.setContentView(view);
        dialog.setCancelable(false);

        tv_status.setText(mLoadingText);
        ll_container.setLayoutParams(new FrameLayout.LayoutParams((int) (ArmsUtils.getScreenWidth(mContext) * 0.4), (int) (ArmsUtils.getScreenWidth(mContext) * 0.4)));
    }

    public void loadLoading() {
        as_status.loadLoading();
    }

    public void loadSuccess() {
        as_status.loadSuccess();
    }

    public void loadFailure() {
        as_status.loadFailure();
    }

    public void cancel() {
        clearLoadingAnim();
        if (dialog != null && dialog.isShowing()) {
            as_status.postDelayed(new Runnable() {
                @Override
                public void run() {
                    dialog.cancel();
                }
            }, mCancelDelayMillis);
        }
    }

    public void setStatusText(String text) {
        tv_status.setText(text);
    }

    public void clearLoadingAnim() {
        if (as_status != null && as_status.getAnimation() != null) {
            as_status.clearAnimation();
        }
    }

    public void show() {
        if (dialog != null) {
            dialog.show();
        }
        loadLoading();
    }

    private OnLoadStautsListener mOnClickListener;

    public void setOnLoadStautsListener(OnLoadStautsListener onClickListener) {
        mOnClickListener = onClickListener;
    }

    public interface OnLoadStautsListener {

        void loadSuccessEnd();

        void loadFailureEnd();
    }
}
