package com.gingersoft.gsa.cloud.ui.view.section;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionHeader;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;

import androidx.annotation.Nullable;

/**
 * Created by Wyh on 2020/1/10.
 */
public class BaseTextSection extends LinearLayout {

    private TextView mTitleTv;

    public BaseTextSection(Context context) {
        this(context, null);
    }

    public BaseTextSection(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        setOrientation(LinearLayout.HORIZONTAL);
        setGravity(Gravity.CENTER_VERTICAL);
        setBackgroundColor(Color.WHITE);
        int paddingHor = QMUIDisplayHelper.dp2px(context, 10);
        int paddingVer = QMUIDisplayHelper.dp2px(context, 8);
        mTitleTv = new TextView(getContext());
        mTitleTv.setTextSize(16);
        mTitleTv.setTypeface(Typeface.DEFAULT_BOLD);
        mTitleTv.setTextColor(getColor(context, R.color.black));
        mTitleTv.setPadding(paddingHor, paddingVer, paddingHor, paddingVer);
        mTitleTv.setGravity(Gravity.CENTER_VERTICAL);
        addView(mTitleTv, new LayoutParams(0, ViewGroup.LayoutParams.WRAP_CONTENT, 1f));
        setBackgroundColor(getColor(context, R.color.theme_white_color));
    }

    private int getColor(Context context, int colorId) {
        return context.getResources().getColor(colorId);
    }

//    public ImageView getArrowView() {
//        return mArrowView;
//    }

    public void render(SectionHeader header, boolean isFold) {
        mTitleTv.setText(header.getText());
    }

    public void setBackgroundColor(int color) {
        if (color != -1)
            setBackgroundColor(color);
    }

//    @Override
//    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
//        super.onMeasure(widthMeasureSpec,  MeasureSpec.makeMeasureSpec(headerHeight, MeasureSpec.EXACTLY));
//    }
}