package com.gingersoft.coldchain_module.di.module;

import com.gingersoft.coldchain_module.mvp.contract.OrderDetailsContract;
import com.gingersoft.coldchain_module.mvp.model.OrderDetailsModel;
import com.jess.arms.di.scope.ActivityScope;

import dagger.Module;
import dagger.Provides;


@Module
public class OrderDetailsModule {
    private OrderDetailsContract.View view;

    /**
     * 构建OrderDetailsModule时,将View的实现类传进来,这样就可以提供View的实现类给presenter
     *
     * @param view
     */
    public OrderDetailsModule(OrderDetailsContract.View view) {
        this.view = view;
    }

    @ActivityScope
    @Provides
    OrderDetailsContract.View provideOrderDetailsView() {
        return this.view;
    }

    @ActivityScope
    @Provides
    OrderDetailsContract.Model provideOrderDetailsModel(OrderDetailsModel model) {
        return model;
    }
}