package com.gingersoft.gsa.delivery_pick_mode.ui.adapter

import androidx.core.content.ContextCompat
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.gingersoft.gsa.delivery_pick_mode.R

class DeliveryAdapter(data: MutableList<String>) : BaseQuickAdapter<String, BaseViewHolder>(R.layout.other_order_delivery_item, data) {

    init {
        setOnItemClickListener { adapter, _, position ->
            selectIndex = position
            adapter.notifyDataSetChanged()
        }
    }

    fun setOnItemClickListener(block: (position: Int) -> Unit) {
        setOnItemClickListener { adapter, _, position ->
            block.invoke(position)
            selectIndex = position
            adapter.notifyDataSetChanged()
        }
    }


    override fun convert(holder: BaseViewHolder, item: String) {
        holder.setText(R.id.tv_delivery_name, item)
        if (holder.adapterPosition == selectIndex) {
            holder.setBackgroundResource(R.id.layout_delivery_item, R.drawable.shape_delivery_item_btn)
            holder.setTextColor(R.id.tv_delivery_name, ContextCompat.getColor(context, R.color.order_state0_color))
        } else {
            holder.setBackgroundResource(R.id.layout_delivery_item, R.drawable.shape_delivery_item_btn_normal)
            holder.setTextColor(R.id.tv_delivery_name, ContextCompat.getColor(context, R.color.color_c8))
        }
    }

    var selectIndex = -1
}
