package com.gingersoft.gsa.cloud.login.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.table.PublicBean;
import com.gingersoft.gsa.cloud.login.mvp.contract.BaseLoginContract;
import com.gingersoft.gsa.cloud.login.mvp.server.LoginService;
import com.gingersoft.gsa.cloud.ui.bean.mode.BrandsBean;
import com.gingersoft.gsa.cloud.ui.bean.mode.LoginBean;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import javax.inject.Inject;

import io.reactivex.Observable;
import okhttp3.RequestBody;

public class BaseLoginModel extends BaseModel implements BaseLoginContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public BaseLoginModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }


    @Override
    public Observable<LoginBean> login(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(LoginService.class)
                .login(requestBody);
    }

    @Override
    public Observable<BrandsBean> getRestaurantList() {
        return mRepositoryManager.obtainRetrofitService(LoginService.class)
                .getRestaurantList();
    }

    @Override
    public Observable<PublicBean> getLoginLimit(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(LoginService.class)
                .getLoginLimit(restaurantId);
    }

    @Override
    public Observable<Object> loginOut(int userId, RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(LoginService.class)
                .loginOut(userId, requestBody);
    }
}
