package com.gingersoft.gsa.cloud.manager.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.gsa.cloud.manager.di.module.TableManageModule;
import com.gingersoft.gsa.cloud.manager.mvp.contract.TableManageContract;

import com.jess.arms.di.scope.ActivityScope;
import com.gingersoft.gsa.cloud.manager.mvp.ui.activity.TableManageActivity;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 05/13/2020 14:47
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
@Component(modules = TableManageModule.class, dependencies = AppComponent.class)
public interface TableManageComponent {
    void inject(TableManageActivity activity);

    @Component.Builder
    interface Builder {
        @BindsInstance
        TableManageComponent.Builder view(TableManageContract.View view);

        TableManageComponent.Builder appComponent(AppComponent appComponent);

        TableManageComponent build();
    }
}