package com.joe.print.mvp.presenter;

import android.app.Application;

import com.gingersoft.gsa.cloud.base.utils.JsonUtils;
import com.gingersoft.gsa.cloud.table.PublicBean;
import com.gingersoft.gsa.cloud.database.bean.PrintCurrencyBean;
import com.jess.arms.integration.AppManager;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.http.imageloader.ImageLoader;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.RequestBody;

import javax.inject.Inject;

import com.jess.arms.utils.RxLifecycleUtils;
import com.joe.print.mvp.contract.PrintAddCurrencyContract;


@ActivityScope
public class PrintAddCurrencyPresenter extends BasePresenter<PrintAddCurrencyContract.Model, PrintAddCurrencyContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    @Inject
    public PrintAddCurrencyPresenter(PrintAddCurrencyContract.Model model, PrintAddCurrencyContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }


    public void addCurrencyPresenter(PrintCurrencyBean printCurrencyBean, boolean isUpdate) {
        RequestBody requestBody = RequestBody.create(MediaType.parse("application/json"), JsonUtils.toJson(printCurrencyBean));
        mModel.addPrinterCurrency(requestBody, isUpdate)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<PublicBean>(mErrorHandler) {
                    @Override
                    public void onNext(PublicBean s) {
                        if (s != null) {
                            mRootView.addSuccess(s.isSuccess());
                        } else {
                            mRootView.addSuccess(false);
                        }
                    }
                });
    }

    private RequestBody getRequestBody(PrintCurrencyBean printCurrencyBean) {
        FormBody.Builder builder = new FormBody.Builder()
                .add("restaurantId", printCurrencyBean.getRestaurantId() + "")
                .add("type", printCurrencyBean.getType() + "")
                .add("foodComplexion", printCurrencyBean.getFoodComplexion() + "")
                .add("modifierComplexion", printCurrencyBean.getModifierComplexion() + "")
                .add("uid", printCurrencyBean.getUid() + "")
                .add("foodIsBold", printCurrencyBean.getFoodIsBold() + "")
                .add("foodFont", printCurrencyBean.getFoodFont() + "")
                .add("foodIsItalic", printCurrencyBean.getFoodIsItalic() + "")
                .add("modifierIsBold", printCurrencyBean.getModifierIsBold() + "")
                .add("modifierFont", printCurrencyBean.getModifierFont() + "")
                .add("modifierIsItalic", printCurrencyBean.getModifierIsItalic() + "")
                .add("numberIsFlip", printCurrencyBean.getNumberIsFlip() + "");
        return builder.build();
    }


}
