package com.joe.print.mvp.print.utils;

import android.content.Intent;
import android.util.Xml;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.utils.okhttpUtils.OkHttp3Utils;
import com.gingersoft.gsa.cloud.bean.WiseposBean;
import com.joe.print.mvp.print.PrintListener;
import com.joe.print.mvp.ui.activity.PrintActivity;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.util.concurrent.TimeoutException;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

public class BBposPrint {

    public void print(String printData, PrintListener listener) {
        WiseposBean wiseposBean = new WiseposBean();
        OkHttp3Utils.get("http://localhost:8080/pos?transactionType=PRINT&isExternal=false&apiVersion=21&printData=" + printData).subscribe(new Observer<String>() {
            @Override
            public void onSubscribe(Disposable d) {

            }

            @Override
            public void onNext(String s) {
                analysisPrintResult(s, wiseposBean, listener);
            }

            @Override
            public void onError(Throwable e) {
                e.printStackTrace();
                if (e instanceof ConnectException) {
                    listener.printFile("無法連接打印，請檢查WisePay是否打開");
                } else if (e instanceof TimeoutException) {
                    backPrintActivity();
                }
            }

            @Override
            public void onComplete() {
                //這個節點解析完成
                if (wiseposBean.getState() != null && wiseposBean.getState().equals("SUCCESS")) {
                    listener.printSuccess();
                } else {
                    listener.printFile("打印失敗");
                }
                backPrintActivity();
            }

            private void backPrintActivity() {
                Intent intent = new Intent(GsaCloudApplication.getAppContext(), PrintActivity.class);
                intent.addFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
                intent.addFlags(Intent.FLAG_ACTIVITY_RESET_TASK_IF_NEEDED);
                intent.addFlags(Intent.FLAG_ACTIVITY_PREVIOUS_IS_TOP);
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                GsaCloudApplication.getAppContext().startActivity(intent);
            }
        });
    }

    private void analysisPrintResult(String s, WiseposBean wiseposBean, PrintListener listener) {
        XmlPullParser xmlPullParser = Xml.newPullParser();
        try {
            xmlPullParser.setInput(new ByteArrayInputStream(s.getBytes()), "utf-8");
            int eventType = xmlPullParser.getEventType();
            while (eventType != XmlPullParser.END_DOCUMENT) {
                switch (eventType) {
                    case XmlPullParser.START_DOCUMENT:
                        //開始解析
                        break;
                    case XmlPullParser.START_TAG:
                        //解析到某一個節點
                        String xmlName = xmlPullParser.getName();
                        switch (xmlName) {
                            case "status":
                                wiseposBean.setState(xmlPullParser.nextText());
                                break;
                            case "ErrorMessage":
                                if (xmlPullParser.nextText().equals("Please login first")) {
                                    listener.printFile("請先登錄WisePay");
                                } else {
                                    listener.printFile("" + xmlPullParser.nextText());
                                }
                                break;
                            case "requestType":
                                wiseposBean.setRequestType(xmlPullParser.nextText());
                                break;
                            default:

                                break;
                        }
                        break;
                    case XmlPullParser.END_TAG:

                        break;
                    default:

                        break;
                }
                eventType = xmlPullParser.next();
            }
        } catch (XmlPullParserException | IOException e) {
            e.printStackTrace();
        }
    }
}
