package com.gingersoft.gsa.cloud.table.mvp.model.discount;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-19
 * 修订历史：2020-09-19
 * 描述: 折扣抽象類{@link MultyDiscount}
 */
public abstract class MultyDiscount {

    /**責任鏈中的下一個對象*/
    protected MultyDiscount nextMultyDiscount;

    public MultyDiscount(MultyDiscount nextMultyDiscount) {
        this.nextMultyDiscount = nextMultyDiscount;
    }

    public double calculate(double money) {
        if (nextMultyDiscount != null) {
            return nextMultyDiscount.calculate(money);
        }
        return money;
    }

}
