package com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.utils.ArmsUtils;

import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */

public class DiscountAdapter extends DefaultAdapter<Discount> {

    private Context mContext;

    private int fontSize;
    private int colHeight;

    private int currentSelectPosition = 0;

    public DiscountAdapter(Context context, List<Discount> infos) {
        super(infos);
        this.mContext = context;

        fontSize = GsaCloudApplication.uiStyleConfiguration.getDiscountFontSize();
        colHeight = GsaCloudApplication.uiStyleConfiguration.getDiscountHeight();

    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<Discount> getHolder(View v, int viewType) {
        return new DiscountItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.meal_item_discount;
    }

    class DiscountItemHolder extends BaseHolder<Discount> {

        @BindView(R2.id.tv_name)
        TextView tv_name;

        public DiscountItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(Discount datasBean, int position) {

            initLayoutParams();
            initName(datasBean);
            setColor(datasBean);
        }

        private void initName(Discount datasBean) {
            String desc = datasBean.getRemark();
            tv_name.setText(desc);
            tv_name.setTextSize(fontSize);
        }

        private void setColor(Discount datasBean) {

            int color = ArmsUtils.getColor(mContext, R.color.light_blue_900);
            int fontColor = ArmsUtils.getColor(mContext, R.color.theme_white_color);

            tv_name.setBackgroundColor(color);
            tv_name.setTextColor(fontColor);
        }

        private void initLayoutParams() {
            ViewGroup.LayoutParams layoutParams = tv_name.getLayoutParams();
            layoutParams.height = colHeight;
            tv_name.setLayoutParams(layoutParams);
        }
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(Discount datasBean, int position);

    }
}
