package com.gingersoft.gsa.cloud.table.mvp.ui.fragment;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.di.component.DaggerFineItemAllComponent;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.SoldoutCtrFood;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;

import com.gingersoft.gsa.cloud.table.mvp.contract.FineItemAllContract;
import com.gingersoft.gsa.cloud.table.mvp.presenter.FineItemAllPresenter;


import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/19/2020 22:15
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class FineItemAllFragment extends BaseFragment<FineItemAllPresenter> implements FineItemAllContract.View {

    @BindView(R2.id.recycle_fine_item_all)
    RecyclerView recycle_fine_item_all;

    @BindView(R2.id.recycle_fine_item_kind_item)
    RecyclerView recycle_fine_item_kind_item;//细项分类详细数据

    private int modCol;

    public static FineItemAllFragment newInstance() {
        FineItemAllFragment fragment = new FineItemAllFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerFineItemAllComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.table_fragment_fine_item_all, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        modCol = GsaCloudApplication.uiStyleConfiguration.getModColumn();

        mPresenter.initAdapter();
        mPresenter.initItemListener(mContext);
    }

    @Override
    public void setData(@Nullable Object data) {

    }

    public void setModifierSoldoutFoodList_Full(List<SoldoutCtrFood> soldoutCtrFoodList) {
        if (soldoutCtrFoodList == null) {
            return;
        }
        mPresenter.setModifierSoldoutFoodList_Full(soldoutCtrFoodList);
    }

    public void updateParentModifierSlodoutFoodList_Full() {
        mPresenter.updateParentModifierSoldoutFoodList_Full();
    }

    public void loadModSasteData(long fid) {
        mPresenter.initModSasteFineItemKindData(fid);
    }

    public void loadModMsgData(long fid) {
        mPresenter.initModMsgFineItemData(fid);
    }

    public void loadModCommData(long fid) {
        mPresenter.initModCommFineItemKindData(fid);
    }

    private List<SoldoutCtrFood> getNewSoldoutCtrFoodList(List<SoldoutCtrFood> soldoutCtrFoodList) {
        List<SoldoutCtrFood> newSoldoutCtrFoodList = new ArrayList<>();
        for (SoldoutCtrFood soldoutCtrFood : soldoutCtrFoodList) {
            SoldoutCtrFood newSoldout = new SoldoutCtrFood(soldoutCtrFood);
            newSoldoutCtrFoodList.add(newSoldout);
        }
        return newSoldoutCtrFoodList;
    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(getCurrentActivity(), message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {

    }

    @Override
    public void setFineItemAllAdapter(DefaultAdapter adapter) {
        recycle_fine_item_all.setAdapter(adapter);
        initFineItemAllRecycleView();
    }

    @Override
    public void setFineItemKindItemAdapter(DefaultAdapter adapter) {
        recycle_fine_item_kind_item.setAdapter(adapter);
        initFineItemTwoRecycleView();
    }

    private GridLayoutManager mFineItemAllRecycleLayoutManager;
    private GridLayoutManager mFineItemTwoRecycleLayoutManager;

    public void initFineItemTwoRecycleView() {
        mFineItemTwoRecycleLayoutManager = new GridLayoutManager(mContext, 1, LinearLayoutManager.VERTICAL, false);
        recycle_fine_item_kind_item.setLayoutManager(mFineItemTwoRecycleLayoutManager);
        recycle_fine_item_kind_item.setItemAnimator(new DefaultItemAnimator());
    }

    public void initFineItemTwoRecycleView2() {
        mFineItemTwoRecycleLayoutManager = new GridLayoutManager(mContext, 1, LinearLayoutManager.HORIZONTAL, false);
        recycle_fine_item_kind_item.setLayoutManager(mFineItemTwoRecycleLayoutManager);
        recycle_fine_item_kind_item.setItemAnimator(new DefaultItemAnimator());
    }

    public void initFineItemAllRecycleView() {
        mFineItemAllRecycleLayoutManager = new GridLayoutManager(mContext, 1, LinearLayoutManager.VERTICAL, false);
        recycle_fine_item_all.setLayoutManager(mFineItemAllRecycleLayoutManager);
        recycle_fine_item_all.setItemAnimator(new DefaultItemAnimator());
    }

    public void initFineItemAllRecycleView2() {
        mFineItemAllRecycleLayoutManager = new GridLayoutManager(mContext, 1, LinearLayoutManager.HORIZONTAL, false);
        recycle_fine_item_all.setLayoutManager(mFineItemAllRecycleLayoutManager);
        recycle_fine_item_all.setItemAnimator(new DefaultItemAnimator());
    }

    @Override
    public void setFineItemAllRecycleSpanCount(int size) {
        if (size > 0) {
            if (size > modCol) {
                initFineItemAllRecycleView();
                mFineItemAllRecycleLayoutManager.setSpanCount(modCol);
            } else {
                initFineItemAllRecycleView2();
            }
        }
    }

    @Override
    public void setFineItemKindItemRecycleSpanCount(int size) {
        if (size > 0) {
            if (size > 5) {
                initFineItemTwoRecycleView();
                mFineItemTwoRecycleLayoutManager.setSpanCount(modCol);
            } else {
                initFineItemTwoRecycleView2();
            }
        }
    }

    @Override
    public RecyclerView getRecycle_fine_adll() {
        return recycle_fine_item_all;
    }

    @Override
    public RecyclerView getRecycle_fine_item_kind_item() {
        return recycle_fine_item_kind_item;
    }

    @Override
    public Activity getCurrentActivity() {
        return (Activity) mContext;
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        //使dialog的生命周期与Fragment同步
        hideLoading();
    }


}
