/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.base64;

import it.sauronsoftware.base64.Shared;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends OutputStream {
    private OutputStream outputStream = null;
    private int buffer = 0;
    private int bytecounter = 0;
    private int linecounter = 0;
    private int linelength = 0;

    public Base64OutputStream(OutputStream outputStream) {
        this(outputStream, 76);
    }

    public Base64OutputStream(OutputStream outputStream, int n) {
        this.outputStream = outputStream;
        this.linelength = n;
    }

    public void write(int n) throws IOException {
        int n2 = (n & 0xFF) << 16 - this.bytecounter * 8;
        this.buffer |= n2;
        ++this.bytecounter;
        if (this.bytecounter == 3) {
            this.commit();
        }
    }

    public void close() throws IOException {
        this.commit();
        this.outputStream.close();
    }

    protected void commit() throws IOException {
        if (this.bytecounter > 0) {
            if (this.linelength > 0 && this.linecounter == this.linelength) {
                this.outputStream.write("\r\n".getBytes());
                this.linecounter = 0;
            }
            char c = Shared.chars.charAt(this.buffer << 8 >>> 26);
            char c2 = Shared.chars.charAt(this.buffer << 14 >>> 26);
            char c3 = this.bytecounter < 2 ? Shared.pad : Shared.chars.charAt(this.buffer << 20 >>> 26);
            char c4 = this.bytecounter < 3 ? Shared.pad : Shared.chars.charAt(this.buffer << 26 >>> 26);
            this.outputStream.write(c);
            this.outputStream.write(c2);
            this.outputStream.write(c3);
            this.outputStream.write(c4);
            this.linecounter += 4;
            this.bytecounter = 0;
            this.buffer = 0;
        }
    }
}

