package com.gingersoft.supply_chain.mvp.ui.widget;

import android.content.Context;
import android.text.InputFilter;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.gingersoft.gsa.cloud.common.utils.inputFilter.InputFilterUtils;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.ui.utils.AppDialog;
import com.gingersoft.supply_chain.R;
import com.lxj.xpopup.impl.ConfirmPopupView;
import com.lxj.xpopup.impl.InputConfirmPopupView;
import com.qmuiteam.qmui.alpha.QMUIAlphaTextView;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/15
 * Time: 9:45
 * Use: 新增分類的彈窗
 */
public class CategoryPopup extends ConfirmPopupView {
    private boolean showDelete;
    private EditText et_input;
    private OnClickListener onDeleteListener;
    private String inputText;
    private final int nameMaxLength = 4;

    public CategoryPopup(@NonNull Context context, CharSequence title, CharSequence content, CharSequence hint, String inputText, boolean showDelete) {
        super(context, R.layout.dialog_new_category);
        setTitleContent(title, content, hint);
        this.showDelete = showDelete;
        this.inputText = inputText;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        findViewById(R.id.iv_create_category_close).setOnClickListener(v -> dialog.dismiss());
        QMUIAlphaTextView tvDelete = findViewById(R.id.tv_category_delete);
        tvDelete.setVisibility(showDelete ? View.VISIBLE : GONE);
        tvDelete.setOnClickListener(onDeleteListener);
        et_input = findViewById(R.id.et_input);
        if (TextUtil.isNotEmptyOrNullOrUndefined(inputText)) {
            if (inputText.length() > nameMaxLength) {
                et_input.setText(inputText.substring(0, 4));
            } else {
                et_input.setText(inputText);
            }
            et_input.setSelection(et_input.length());
        }
        et_input.setFilters(new InputFilter[]{InputFilterUtils.getLengthFilter(getContext(), 4), InputFilterUtils.getChAndEnAndNumInputFilter(getContext())});
    }

    public EditText getEditText() {
        return et_input;
    }

    public CategoryPopup setOnDeleteListener(OnClickListener onDeleteListener) {
        this.onDeleteListener = onDeleteListener;
        return this;
    }
}
