package com.gingersoft.gsa.cloud.common.config.globalconfig.applyOptions;

import android.content.Context;
import com.gingersoft.gsa.cloud.common.BuildConfig;
import com.gingersoft.gsa.cloud.common.config.OkHttpConfig;
import com.jess.arms.di.module.ClientModule;

import java.io.File;
import java.util.concurrent.TimeUnit;

import me.jessyan.progressmanager.ProgressManager;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.Cache;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;


public class MyRetrofitConfiguration implements ClientModule.RetrofitConfiguration {
    @Override
    public void configRetrofit(Context context, Retrofit.Builder builder) {
        // 配置多BaseUrl支持
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (BuildConfig.DEBUG) {
//            clientBuilder.addInterceptor(new LoggingInterceptor());//使用自定义的Log拦截器
        }
        clientBuilder.connectTimeout(OkHttpConfig.CONNECT_TIMEOUT, TimeUnit.SECONDS);
        clientBuilder.writeTimeout(OkHttpConfig.REQUEST_TIMEOUT, TimeUnit.SECONDS);
        clientBuilder.readTimeout(OkHttpConfig.REQUEST_TIMEOUT, TimeUnit.SECONDS);
        clientBuilder.cache(new Cache(new File(OkHttpConfig.CACHE_DIRECTORY), OkHttpConfig.CACHE_MAXSIZE));
        //使用一行代码监听 Retrofit／Okhttp 上传下载进度监听,以及 Glide 加载进度监听 详细使用方法查看 https://github.com/JessYanCoding/ProgressManager
        ProgressManager.getInstance().with(clientBuilder);
        //让 Retrofit 同时支持多个 BaseUrl 以及动态改变 BaseUrl. 详细使用请方法查看 https://github.com/JessYanCoding/RetrofitUrlManager
        RetrofitUrlManager.getInstance().with(clientBuilder).build();

        builder.client(clientBuilder.build());
    }
}
