package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodEncodeSn;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/3/26
 * Time: 19:53
 * Use:
 */
public class SnCodesAdapter extends BaseQuickAdapter<PurchaseFoodEncodeSn, BaseViewHolder> {
    private int[] colors = new int[]{R.color.color_f9, R.color.white};

    public SnCodesAdapter(@Nullable List<PurchaseFoodEncodeSn> data) {
        super(R.layout.include_sn_item, data);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, PurchaseFoodEncodeSn purchaseFoodEncodeSn) {
        int colorRes = getColor(getContext(), colors[viewHolder.getAdapterPosition() % 2]);
        viewHolder.setBackgroundColor(R.id.layout_sn_item, colorRes);
        setTextColor(viewHolder, getColor(getContext(), R.color.color_3c));

        viewHolder.setText(R.id.tv_serial_number, String.valueOf(viewHolder.getAdapterPosition() +1));
        viewHolder.setText(R.id.tv_sn_code, String.valueOf(purchaseFoodEncodeSn.getEncodeSnNo()));
        viewHolder.setText(R.id.tv_operator, String.valueOf(purchaseFoodEncodeSn.userName));
        viewHolder.setText(R.id.tv_time, TimeUtils.getStringByFormat(purchaseFoodEncodeSn.updateTime, TimeUtils.DATE_FORMAT_DATE));
    }

    private void setTextColor(@NotNull BaseViewHolder viewHolder, int textColorRes) {
        viewHolder.setTextColor(R.id.tv_serial_number, textColorRes);
        viewHolder.setTextColor(R.id.tv_sn_code, textColorRes);
        viewHolder.setTextColor(R.id.tv_operator, textColorRes);
        viewHolder.setTextColor(R.id.tv_time, textColorRes);
    }

    private int getColor(Context context, int colorRes) {
        return ContextCompat.getColor(context, colorRes);
    }

}
