package com.gingersoft.gsa.cloud.table.mvp.action.discount;

import android.app.Activity;

import com.gingersoft.gsa.cloud.order.bean.discount.MemberWalletCoupon;
import com.gingersoft.gsa.cloud.common.patterns.Strategy;
import com.gingersoft.gsa.cloud.order.discount.NomalDiscount;
import com.jess.arms.utils.ArmsUtils;

import java.util.List;

import lombok.Builder;
import lombok.Setter;

/**
 * @author : bin
 * @create date: 2020-10-27
 * @update date: 2020-10-27
 * @description:賬單優惠券邏輯
 */
@Builder
@Setter
public class BillCouponAction implements Strategy<MemberWalletCoupon> {

    private Activity context;

    /**
     * 賬單優惠券列表
     */
    private List<NomalDiscount> nomalDiscountList;

    private double wholeAmount;

    private OnCallBackListener listener;

    private String cashStr;


    @Override
    public void action(MemberWalletCoupon coupon) {
        if (listener == null) {
            return;
        }
        if (coupon.getBillMinAmount() > wholeAmount) {
            //小於最小賬單金額
            ArmsUtils.makeText(context, "小於最小賬單金額" + cashStr + coupon.getBillMinAmount() + " 無法使用此優惠券");
            return;
        }

        listener.preformAddCoupon(coupon.clone());
    }

    @Override
    public void destroy() {

    }


    public interface OnCallBackListener {

        void preformAddCoupon(MemberWalletCoupon discount);
    }

}
