package com.gingersoft.gsa.cloud.pay;

import com.gingersoft.gsa.cloud.common.utils.AppDevices;
import com.gingersoft.gsa.cloud.pay.device.pos.PosPayAction;
import com.gingersoft.gsa.cloud.pay.device.pos.bbpos.BBPosDevice;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.HywebDevice;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.YedpayDevice;

/**
 * @作者: bin
 * @創建時間: 2021-04-14 12:28
 * @更新時間: 2021-04-14 12:28
 * @描述:
 */
public class PayDeviceFactory {

    public static PosPayAction createPayDevice() {
        if (AppDevices.isHywebPos()) {
            return HywebDevice.newInstance();
        } else if (AppDevices.isBBPos()) {
            return BBPosDevice.newInstance();
        } else if (AppDevices.isYedpay()) {
            return YedpayDevice.newInstance();
        }
        return YedpayDevice.newInstance();
    }

}
