package com.gingersoft.gsa.cloud.pay.device.pos.yedpay.lifecycle.presenter;

import android.app.Application;
import android.content.Intent;
import android.net.Uri;
import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.rxjava.ErrorHandleSingleSubscriber;
import com.gingersoft.gsa.cloud.common.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.pay.PayStep;
import com.gingersoft.gsa.cloud.pay.PaymentControl;
import com.gingersoft.gsa.cloud.pay.RequestParms;
import com.gingersoft.gsa.cloud.pay.ResultCallback;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.YedpayCommand;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.constant.YedpayConstant;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.lifecycle.model.bean.YedpayFindSaleStatusBean;
import com.jess.arms.integration.AppManager;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.http.imageloader.ImageLoader;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import okhttp3.FormBody;
import okhttp3.RequestBody;
import javax.inject.Inject;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.lifecycle.contract.YedpayContract;
import com.jess.arms.utils.RxLifecycleUtils;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/30/2021 16:23
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class YedpayPresenter extends BasePresenter<YedpayContract.Model, YedpayContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    private RequestParms mRequestParms;
    private ResultCallback mResultCallback;

    @Inject
    public YedpayPresenter(YedpayContract.Model model, YedpayContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void findSaleStatus(String transactionId, long orderId, int payType, int restaurantId) {
        RequestBody requestBody = new FormBody.Builder()
                .add("transactionId", transactionId)
                .add("orderId", orderId + "")
                .add("payType", payType + "")
                .add("restaurantId", restaurantId + "")
                .build();
        mModel.findSaleStatus(requestBody)
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSingleSubscriber<BaseResult>(mErrorHandler) {

                    @Override
                    public void onSuccess(BaseResult result) {
                        if (result.isSuccess()) {
                            YedpayFindSaleStatusBean saleStatusBean = GsonUtils.GsonToBean(result.getData(), YedpayFindSaleStatusBean.class);
                            if (saleStatusBean != null) {
                                if (saleStatusBean.getStatus() == YedpayConstant.Status.PAY_STATUS_0) {
                                    mRootView.showStatusLoadingDialog(PayStep.SUCCESS);
                                    if (mResultCallback != null) {
                                        mResultCallback.onSuccess();
                                    }
                                } else {
                                    mRootView.showStatusLoadingDialog(PayStep.FAILURE);
                                    if (mResultCallback != null) {
                                        mResultCallback.onFailure(null);
                                    }
                                }
                            } else {
                                mRootView.showStatusLoadingDialog(PayStep.FAILURE);
                                if (mResultCallback != null) {
                                    mResultCallback.onFailure(null);
                                }
                            }
                        } else {
                            mRootView.showStatusLoadingDialog(PayStep.FAILURE);
                            mRootView.showMessage(result.getErrMsg());
                            if (mResultCallback != null) {
                                mResultCallback.onFailure(null);
                            }
                        }
                    }

                    @Override
                    public void onError(Throwable t) {
                        super.onError(t);
                        mRootView.showStatusLoadingDialog(PayStep.FAILURE);
                        if (mResultCallback != null) {
                            mResultCallback.onFailure(t);
                        }
                    }
                });
    }

    public void refundOrder(String refundReason, long orderId, int payType, int restaurantId) {
        RequestBody requestBody = new FormBody.Builder()
                .add("refundReason", refundReason)
                .add("orderId", String.valueOf(orderId))
                .add("payType", String.valueOf(payType))
                .add("restaurantId", String.valueOf(restaurantId))
                .build();
        mModel.refundOrder(requestBody)
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSingleSubscriber<BaseResult>(mErrorHandler) {

                    @Override
                    public void onSuccess(BaseResult result) {
                        if (result.isSuccess()) {
                            mRootView.showStatusLoadingDialog(PayStep.SUCCESS);
                            if (mResultCallback != null) {
                                mResultCallback.onSuccess();
                            }
                        } else {
                            mRootView.showStatusLoadingDialog(PayStep.FAILURE);
                            if (mResultCallback != null) {
                                mResultCallback.onFailure(null);
                            }
                        }
                    }

                    @Override
                    public void onError(Throwable t) {
                        super.onError(t);
                        mRootView.showStatusLoadingDialog(PayStep.FAILURE);
                        if (mResultCallback != null) {
                            mResultCallback.onFailure(t);
                        }
                    }
                });
    }

    public void excutePayFlow(RequestParms requestParms) {
        this.mRequestParms = requestParms;
        this.mResultCallback = mRequestParms.getResultCallback();

        mRequestParms.setCallback(yedpayCommand);

        switch (requestParms.getAction()) {
            case SALE:
                PaymentControl.newInstance().pay(requestParms);
                break;
            case REFUND:
                PaymentControl.newInstance().refund(requestParms);
                break;
        }
    }

    private YedpayCommand yedpayCommand = new YedpayCommand() {

        @Override
        public void callSaleUri(String uri) {
            Uri uri2 = Uri.parse(uri);
            Intent intent = new Intent(Intent.ACTION_VIEW, uri2);
            mRootView.startActivityForResult(intent);
        }

        @Override
        public void refundResult(boolean result) {
            refundOrder(mRequestParms.getRefundReason(), mRequestParms.getOrderId(), mRequestParms.getPayType(), mRequestParms.getResturantId());
        }

        @Override
        public void querySaleStatus(String uri) {
            Uri uri2 = Uri.parse(uri);
            Intent intent = new Intent(Intent.ACTION_VIEW, uri2);
            mRootView.startActivityForResult(intent);
        }

        @Override
        public void queryRefundStatus(String uri) {
            Uri uri2 = Uri.parse(uri);
            Intent intent = new Intent(Intent.ACTION_VIEW, uri2);
            mRootView.startActivityForResult(intent);
        }
    };

}
