package com.gingersoft.gsa.cloud.table.mvp.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;

import com.gingersoft.gsa.cloud.base.common.bean.TableBean;
import com.gingersoft.gsa.cloud.base.utils.VibratorUtils;
import com.gingersoft.gsa.cloud.base.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.di.component.DaggerInputTableComponent;
import com.gingersoft.gsa.cloud.table.mvp.contract.InputTableContract;
import com.gingersoft.gsa.cloud.table.mvp.presenter.InputTablePresenter;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.TableActivity;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import butterknife.BindView;
import butterknife.OnClick;
import butterknife.OnLongClick;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/28/2019 17:32
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class InputTableFragment extends BaseFragment<InputTablePresenter> implements InputTableContract.View {

    @BindView(R2.id.ed_value)
    EditText ed_value;
    @BindView(R2.id.iv_clear_account)
    ImageView iv_clear_account;

    @BindView(R2.id.btn_0)
    QMUIAlphaButton btn_0;
    @BindView(R2.id.btn_1)
    QMUIAlphaButton btn_1;
    @BindView(R2.id.btn_2)
    QMUIAlphaButton btn_2;
    @BindView(R2.id.btn_3)
    QMUIAlphaButton btn_3;
    @BindView(R2.id.btn_4)
    QMUIAlphaButton btn_4;
    @BindView(R2.id.btn_5)
    QMUIAlphaButton btn_5;
    @BindView(R2.id.btn_6)
    QMUIAlphaButton btn_6;
    @BindView(R2.id.btn_7)
    QMUIAlphaButton btn_7;
    @BindView(R2.id.btn_8)
    QMUIAlphaButton btn_8;
    @BindView(R2.id.btn_9)
    QMUIAlphaButton btn_9;
    @BindView(R2.id.btn_clear)
    QMUIAlphaButton btn_clear;
    @BindView(R2.id.btn_A)
    QMUIAlphaButton btn_A;
    @BindView(R2.id.btn_B)
    QMUIAlphaButton btn_B;
    @BindView(R2.id.btn_C)
    QMUIAlphaButton btn_C;
    @BindView(R2.id.btn_more)
    QMUIAlphaButton btn_more;
    @BindView(R2.id.btn_right)
    QMUIAlphaButton btn_right;

    private TableActivity mActivity;
    private List<TableBean.DataBean> mTableList = new ArrayList<>();

    private String t_name = "";
    private String t_splite = "";

    private boolean isClose = false;
    private boolean isFirstNumberClick = true;
    private String inputstr = "";
    private String letter = "-ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private int letterindex;
    private boolean Splitemodal = false;
    private boolean keystatestand = false;


    public static InputTableFragment newInstance() {
        InputTableFragment fragment = new InputTableFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerInputTableComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.table_fragment_input_table, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        mActivity = (TableActivity) getActivity();

        ed_value.setOnFocusChangeListener(mOnFocusChangeListener);
        ed_value.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (ed_value.getText().toString().equals("")) {
                    iv_clear_account.setVisibility(View.GONE);
                } else {
                    iv_clear_account.setVisibility(View.VISIBLE);
                }
            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        });
    }

    private View.OnFocusChangeListener mOnFocusChangeListener = new View.OnFocusChangeListener() {
        @Override
        public void onFocusChange(View v, boolean hasFocus) {
            if (v.getId() == R.id.ed_value && hasFocus) {
                //賬號框獲得焦點
                if (ed_value.getText() != null && ed_value.getText().toString().length() > 0) {
                    iv_clear_account.setVisibility(View.VISIBLE);
                } else {
                    iv_clear_account.setVisibility(View.GONE);
                }
            } else {
                iv_clear_account.setVisibility(View.GONE);
            }
        }
    };

    private void initDefalutText() {
        if (letter.length() > 1)
            btn_A.setText(letter.substring(0, 1));
        if (letter.length() > 2)
            btn_B.setText(letter.substring(1, 2));
        if (letter.length() > 3)
            btn_C.setText(letter.substring(2, 3));

        if (btn_A.getText().equals("-")) {
            btn_A.setTag(97);
        } else {
            btn_A.setTag(55);
        }
        if (btn_B.getText().equals("-")) {
            btn_B.setTag(97);
        } else {
            btn_B.setTag(56);
        }

        if (btn_C.getText().equals("-")) {
            btn_C.setTag(97);
        } else {
            btn_C.setTag(57);
        }

        btn_more.setText("…");

        ed_value.setText("");
        t_name = "";
        ed_value.setHint("please input table");
    }

    @OnLongClick({R2.id.btn_clear})
    public boolean clearClick() {
        inputstr = "";
        ed_value.setText(inputstr);
        t_name = "";
//        GSAApplication.tableContract.setTableno("");
        return false;
    }

    @OnClick({R2.id.btn_0, R2.id.btn_1, R2.id.btn_2, R2.id.btn_3, R2.id.btn_4, R2.id.btn_5, R2.id.btn_6, R2.id.btn_7, R2.id.btn_8
            , R2.id.btn_9, R2.id.btn_A, R2.id.btn_B, R2.id.btn_C, R2.id.btn_more, R2.id.btn_right, R2.id.btn_clear, R2.id.iv_clear_account})
    public void onClick(View v) {

        VibratorUtils.pressButtonSound(getActivity());

//        GSAApplication.tableContract.setIsSplite(false);
//        GSAApplication.tableContract.setTableno_split("");

        if (v.getId() == R.id.iv_clear_account) {
            if (inputstr.length() > 0) {
                String sr = inputstr.substring(inputstr.length() - 1, inputstr.length());
                //将获取到的sr进行对比
                String ss = "";
                if (sr.equals("-")) {
                    Splitemodal = false;
                }
                if (Splitemodal) {
                    ss = t_name.substring(t_name.length() - 1, t_name.length());
                    if (t_splite.length() > 0) {
                        String ss1 = t_splite.substring(t_splite.length() - 1, t_splite.length());
                        if (ss1.equals(sr)) {
                            t_splite = t_splite.substring(0, t_splite.length() - 1);
                        }
                    }
                } else {
                    if (ss.equals(sr)) {
                        t_name = t_name.substring(0, t_name.length() - 1);
                    }
                }
                inputstr = inputstr.substring(0, inputstr.length() - 1);
                ed_value.setText(inputstr);
            }
        } else {
            int i = Integer.parseInt(v.getTag().toString());
            Button btn = (Button) v;
            String s = btn.getText().toString();

            switch (i) {
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 7:
                case 8:
                case 9:
                    if (isFirstNumberClick == true) {
                        isFirstNumberClick = false;
                        inputstr = "";
                        t_splite = "";
                        Splitemodal = false;
                    }
                    inputstr = inputstr + s;
                    ed_value.setText(inputstr);
//                GSAApplication.tableContract.setTableno(inputstr);
                    if (Splitemodal) {
                        t_splite = t_splite + s;
                    } else {
                        t_name = t_name + s;
                    }
                    break;
                case 55:
                case 56:
                case 57:
                    if (isFirstNumberClick == true) {
                        isFirstNumberClick = false;
                        inputstr = "";
                        t_splite = "";
                        Splitemodal = false;
                    }
                    if (((Button) v).getText() != " ") {
                        inputstr = inputstr + ((Button) v).getText();
                        ed_value.setText(inputstr);
                        if (Splitemodal) {
                            t_splite = t_splite + s;
                        } else {
                            t_name = t_name + s;
                        }
                    }
                    break;
                case 58:
                    setKeystate();
                    break;
                case 97://"-"号
                    Splitemodal = true;

                    //同时写入"-"号
                    inputstr = inputstr + "-";
                    t_splite = "";
                    ed_value.setText(inputstr);
                    break;
                case 98: //√
                    t_name = ed_value.getText().toString();

                    goToMealStandBefore();

                    inputstr = "";
                    ed_value.setText("");
                    break;
                case 99: //clear button
                    inputstr = "";
                    ed_value.setText("");
                    break;
            }
        }

    }

    private void goToMealStandBefore() {
        if (Splitemodal) {
            Splitemodal = false;
            load_meal_before_splite();
            return;
        }

        TableBean.DataBean table = getTableByName(t_name);

        if (table != null) {
            mActivity.clickTableItem(table);
        } else {
            showMessage("未找到該檯號!");
        }
    }

    private void load_meal_before_splite() {
        t_name = t_name.substring(0, t_name.indexOf("-"));
//        showLoading(LanguageUtils.get_language_system(getActivity(), "comm.gettabledata", "get tabledata-now"));
//
//        mActivity.toOpen(this);
    }

    public void setKeystate() {
        if (keystatestand) {
            //正常情况下的：
            btn_0.setText("0");
            btn_1.setText("1");
            btn_2.setText("2");
            btn_3.setText("3");
            btn_4.setText("4");
            btn_5.setText("5");
            btn_6.setText("6");
            btn_7.setText("7");
            btn_8.setText("8");
            btn_9.setText("9");
            if (letter.length() > 1)
                btn_A.setText(letter.substring(0, 1));
            if (letter.length() > 2)
                btn_B.setText(letter.substring(1, 2));
            if (letter.length() > 3)
                btn_C.setText(letter.substring(2, 3));
        } else {
            //按下btn_more情况下的：
            if (letter.length() > 4)
                btn_A.setText(letter.substring(3, 4));
            if (letter.length() > 5)
                btn_7.setText(letter.substring(4, 5));
            if (letter.length() > 6)
                btn_8.setText(letter.substring(5, 6));
            if (letter.length() > 7)
                btn_9.setText(letter.substring(6, 7));
            if (letter.length() > 8)
                btn_B.setText(letter.substring(7, 8));
            if (letter.length() > 9)
                btn_4.setText(letter.substring(8, 9));
            if (letter.length() > 10)
                btn_5.setText(letter.substring(9, 10));
            if (letter.length() > 11)
                btn_6.setText(letter.substring(10, 11));
            if (letter.length() > 12)
                btn_C.setText(letter.substring(11, 12));
            if (letter.length() > 13)
                btn_1.setText(letter.substring(12, 13));
            if (letter.length() > 14)
                btn_2.setText(letter.substring(13, 14));
            if (letter.length() > 15)
                btn_3.setText(letter.substring(14, 15));
            if (letter.length() > 16)
                btn_0.setText(letter.substring(15, 16));

            if (btn_A.getText().equals("-")) {
                btn_A.setTag(97);
            } else {
                btn_A.setTag(55);
            }
            if (btn_B.getText().equals("-")) {
                btn_B.setTag(97);
            } else {
                btn_B.setTag(56);
            }
            if (btn_C.getText().equals("-")) {
                btn_C.setTag(97);
            } else {
                btn_C.setTag(57);
            }
        }

        keystatestand = !keystatestand;
    }


    @Override
    public void setData(@Nullable Object data) {
        if (data != null && data instanceof Message) {
            switch (((Message) data).what) {
                case 0:
                    break;
                case 1://刷新全部数据
                    List<TableBean.DataBean> datasBeans = (List<TableBean.DataBean>) ((Message) data).obj;
                    mTableList.clear();
                    mTableList.addAll(datasBeans);
                    break;
                default:
                    //do something
                    break;
            }
        }
    }

    private TableBean.DataBean getTableByName(String name) {
        for (int i = 0; i < mTableList.size(); i++) {
            TableBean.DataBean dataBean = mTableList.get(i);
            if (dataBean.getTableName().equals(name)) {
                return dataBean;
            }
        }
        return null;
    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
//        ArmsUtils.snackbarText(message);
        ToastUtils.show(mContext, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {

    }
}
